import React from 'react';
import { Button, Nav, Navbar } from 'react-bootstrap';
import { LinkContainer } from 'react-router-bootstrap';
import './MegaNavbar.css';
import menu from '../menu.json';
import { Link } from 'react-router-dom';

const MegaNavbar = () => {
  return (
    <nav className='navbar navbar-expand-md navbar-dark bg-dark'>
      <div className='container-fluid'>
        {/* <LinkContainer to='/'>
          <Navbar.Brand>S4U</Navbar.Brand>
        </LinkContainer> */}
        {/* <button
          className='navbar-toggler'
          type='button'
          // data-bs-toggle='collapse'
          data-bs-toggle='offcanvas'
          data-bs-target='#main_nav'
          aria-expanded='false'
          aria-label='Toggle navigation'
        >
          <span className='navbar-toggler-icon' />
        </button> */}
        <button
          className='navbar-toggler'
          type='button'
          data-bs-toggle='offcanvas'
          data-bs-target='#offcanvasDarkNavbar'
          aria-controls='offcanvasDarkNavbar'
        >
          <span className='navbar-toggler-icon'></span>
        </button>
        {/* <div className='collapse navbar-collapse text-center' id='main_nav'> */}
        <div
          className='offcanvas offcanvas-end text-bg-dark'
          tabindex='-1'
          id='offcanvasDarkNavbar'
          aria-labelledby='offcanvasDarkNavbarLabel'
        >
          <div className='offcanvas-header'>
            <h5 className='offcanvas-title' id='offcanvasDarkNavbarLabel'>
              Speed4You
            </h5>
            <button
              type='button'
              className='btn-close btn-close-dark'
              data-bs-dismiss='offcanvas'
              aria-label='Close'
            ></button>
          </div>

          <div className='offcanvas-body'>
            {/* <ul className='navbar-nav nav nav-pills nav-justified'> */}
            <ul className='navbar-nav text-center flex-grow-1 pe-3 nav nav-justified'>
              {/* <li className='nav-item active'>
              <LinkContainer to='/login'>
                <Nav.Link>LOGIN</Nav.Link>
              </LinkContainer>
            </li> */}
              {menu.map((menuItem, i) => (
                <>
                  {menuItem.subMenu ? (
                    <li className='nav-item dropdown has-megamenu' key={i}>
                      <Button
                        className='nav-link dropdown-toggle'
                        data-bs-toggle='dropdown'
                        variant='transparent'
                      >
                        <span className='btn btn-outline-light rounded-pill'>
                          {menuItem.name.toUpperCase()}
                        </span>
                      </Button>

                      <div
                        className='dropdown-menu megamenu text-center'
                        role='menu'
                      >
                        <div className='row g-3'>
                          <div className='col-lg-12 col-12'>
                            <div className='col-megamenu'>
                              {/* <h6 className='title'>Title Menu One</h6> */}
                              <ul className='list-unstyled'>
                                {menuItem.subMenu.map((submenuItem, j) => (
                                  <li key={j}>
                                    <Link to={submenuItem.url}>
                                      <span className='btn btn-outline-light rounded-pill'>
                                        {submenuItem.name.toUpperCase()}
                                      </span>
                                    </Link>
                                  </li>
                                ))}
                              </ul>
                            </div>{' '}
                            {/* col-megamenu.// */}
                          </div>
                        </div>
                        {/* end row */}
                      </div>
                    </li>
                  ) : (
                    <li className='nav-item' key={i}>
                      <LinkContainer to={menuItem.url}>
                        {/* <Nav.Link>{menuItem.name.toUpperCase()}</Nav.Link> */}
                        <Nav.Link>
                          <span className='btn btn-outline-light rounded-pill '>
                            {menuItem.name.toUpperCase()}
                          </span>
                        </Nav.Link>
                      </LinkContainer>
                    </li>
                  )}
                </>
              ))}
            </ul>
          </div>
        </div>{' '}
        {/* navbar-collapse.// */}
      </div>{' '}
      {/* container-fluid.// */}
    </nav>
  );
};

export default MegaNavbar;
