<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see    https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 4.3.1
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters('woocommerce_product_tabs', array());
$i = $j = 0;
if (!empty($tabs)) : ?>

<div class="product-info-tabs">
    <div class="prod-tabs tabs-box">
        <ul class="nav nav-tabs tab-btns tab-buttons">
            <?php foreach ($tabs as $key => $tab) : ?>
            <?php $cl = ($j == 0) ? ' active active-btn' : ''; ?>
            <li class="tab-btn">
                <a href="#<?php echo esc_attr($key); ?>" data-toggle="tab" class="<?php print esc_html($cl); ?>">
                    <?php echo apply_filters('woocommerce_product_' . $key . '_tab_title', esc_html($tab['title']), $key); ?>
                </a>
            </li>
            <?php $j++; endforeach; ?>
        </ul>

        <div class="tab-content pro-nepr">
            <?php foreach ($tabs as $key => $tab) : ?>
            <?php $cl = ($i == 0) ? 'active show active-tab' : ''; ?>
            <div class="tab-pane tab <?php print esc_html($cl); ?>" id="<?php echo esc_attr($key); ?>">
                <?php if (isset($tab['callback'])) {
                    call_user_func($tab['callback'], $key, $tab);
                } ?>
            </div>
            <?php $i++; endforeach; ?>
        </div>
    </div>
</div>


<?php endif; ?>
