<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package nextbit
 */

get_header();

$blog_column = is_active_sidebar( 'blog-sidebar' ) ? 'content-side col-lg-8 col-md-12 col-sm-12' : 'content-side col-lg-12 col-md-12 col-sm-12';

?>

<section class="sidebar-page-container nextbit-blog-page">
    <div class="auto-container">
		<div class="row clearfix">
			<div class="<?php print esc_attr( $blog_column ); ?>">
				<div class="blog-detail">
					<div class="inner-box">
						<?php
							while ( have_posts() ):
							the_post();

							get_template_part( 'post-formats/content', get_post_format() );

						?>
						<?php if(!empty(get_previous_post() || get_next_post()) ) : ?>
						<div class="more-posts">
							<div class="clearfix">
								<?php
									$nextbit_prev_post = get_previous_post();
									if($nextbit_prev_post) :
								?>
								<div class="prev pull-left">
									<a href="<?php print get_the_permalink($nextbit_prev_post); ?>">
										<span class="fa fa-angle-left"></span>&nbsp; <?php print esc_html__( 'Previous Post', 'nextbit' );?>
									</a>
								</div>
								<?php
									endif;
									$nextbit_next_post = get_next_post();
									if ( $nextbit_next_post ) :
								?>
								<div class="next pull-right">
									<a href="<?php print get_the_permalink($nextbit_next_post); ?>">
										<?php print esc_html__( 'Next Post', 'nextbit' );?> &nbsp; <span class="fa fa-angle-right"></span>
									</a>
								</div>
								<?php endif; ?>
							</div>
						</div>
					<?php endif; ?>
					</div>
					<?php
						get_template_part( 'post-formats/biography' );
					?>

					<?php
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ):
						comments_template();
					endif;

					endwhile; // End of the loop.

					?>
				</div>
			</div>
			<?php if ( is_active_sidebar( 'blog-sidebar' ) ): ?>
		        <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
					<aside class="sidebar sticky-top">
						<?php get_sidebar();?>
	            	</aside>
	            </div>
			<?php endif;?>
		</div>
	</div>
</section>

<?php
get_footer();
