<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package nextbit
 */

get_header();

$blog_column = is_active_sidebar( 'blog-sidebar' ) ? 'content-side col-lg-8 col-md-12 col-sm-12' : 'content-side col-lg-12 col-md-12 col-sm-12';

?>

<section class="sidebar-page-container nextbit-blog-page search-page-wrapper">
    <div class="auto-container">
        <div class="row clearfix">
			<div class="<?php print esc_attr( $blog_column ); ?>">
                <?php
					if ( have_posts() ):
				?>
				<div class="result-bar page-header d-none">
					<h1 class="page-title"><?php esc_html_e( 'Search Results For:', 'nextbit' );?> <?php print get_search_query();?></h1>
				</div>
				<?php
					while ( have_posts() ): the_post();
						get_template_part( 'post-formats/content', 'search' );
					endwhile;
				?>
				<div class="pagination-wrap pt-10">
					<?php nextbit_pagination( '<i class="fas fa-angle-double-left"></i>', '<i class="fas fa-angle-double-right"></i>', '', [ 'class' => '' ] );?>
				</div>
				<?php
					else:
						get_template_part( 'post-formats/content', 'none' );
					endif;
				?>
            </div>
			<?php if ( is_active_sidebar( 'blog-sidebar' ) ): ?>
		        <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
					<aside class="sidebar sticky-top">
						<?php get_sidebar();?>
	            	</aside>
	            </div>
			<?php endif;?>
        </div>
    </div>
</section>

<?php
get_footer();
