<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package nextbit
 */

    if ( is_single() ): ?>
    <article id="post-<?php the_ID();?>" <?php post_class( 'format-standrad' );?>>
        <?php if ( has_post_thumbnail() ): ?>
        <div class="image">
            <?php the_post_thumbnail( 'full', ['class' => 'img-responsive'] ); ?>
        </div>
        <?php endif; ?>
        <div class="lower-content">
            <ul class="post-meta">
                <li><span class="icon far fa-user"></span>
                      <a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) );?>"><?php print ucfirst(get_the_author()); ?></a>
                </li>
                <?php
                        $comment_number = get_comments_number();
                        if($comment_number == 1) :
                    ?>
                    <li><span class="icon far fa-comments"></span>
                        <?php print get_comments_number(); ?> <?php print esc_html__('comment', 'nextbit'); ?></li>

                    <?php else : ?>

                    <li><span class="icon far fa-comments"></span>
                        <?php print get_comments_number(); ?> <?php print esc_html__('comments', 'nextbit'); ?></li>

                    <?php endif; ?>
            </ul>
            <div class="details_content_single">
            <?php the_content();?>
                <?php
                    wp_link_pages( [
                        'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'nextbit' ),
                        'after'       => '</div>',
                        'link_before' => '<span class="page-number">',
                        'link_after'  => '</span>',
                    ] );
                ?>
            </div>
            <?php print nextbit_get_tag(); ?>
        </div>

    </article>
    <?php
        else: ?>

    <article id="post-<?php the_ID();?>" <?php post_class( 'news-block-two blog_standrad_layout' );?>>
        <div class="inner-box">
            <?php if ( has_post_thumbnail() ): ?>
            <div class="image">
                <a class="item_image" href="<?php the_permalink();?>">
                    <?php the_post_thumbnail( 'full', ['class' => 'img-responsive'] ); ?>
                </a>
            </div>
            <?php endif; ?>

            <div class="lower-content">
                <ul class="post-meta">
                    <li><span class="icon far fa-user"></span>
                          <a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) );?>"><?php print ucfirst(get_the_author()); ?></a>
                    </li>
                    <?php
                        $comment_number = get_comments_number();
                        if($comment_number == 1) :
                    ?>
                    <li><span class="icon far fa-comments"></span>
                        <?php print get_comments_number(); ?> <?php print esc_html__('comment', 'nextbit'); ?></li>

                    <?php else : ?>

                    <li><span class="icon far fa-comments"></span>
                        <?php print get_comments_number(); ?> <?php print esc_html__('comments', 'nextbit'); ?></li>

                    <?php endif; ?>
                </ul>
                <h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>
                <div class="text"><?php the_excerpt();?></div>

                <?php
                if ( 'product' != get_post_type() ) :
                    if ( rtl_enable() ) {
                        $nextbit_blog_btn = get_theme_mod( 'nextbit_blog_btn_rtl', 'Read More' );
                    } else {
                        $nextbit_blog_btn = get_theme_mod( 'nextbit_blog_btn', 'Read More' );
                    }
                    $nextbit_blog_btn_switch = get_theme_mod( 'nextbit_blog_btn_switch', true );
                if ( !empty( $nextbit_blog_btn_switch ) ): ?>
                <a class="theme-btn btn-style-four" href="<?php the_permalink();?>">
                    <span class="txt"><?php print esc_html( $nextbit_blog_btn );?> <i class="lnr lnr-arrow-right"></i></span>
                </a>
                <?php endif; ?>
                <?php endif; ?>

                <?php
                if ( 'product' == get_post_type() ) :
                    if ( rtl_enable() ) {
                        $nextbit_blog_btn = get_theme_mod( 'nextbit_blog_btn_rtl', 'View Product' );
                    } else {
                        $nextbit_blog_btn = get_theme_mod( 'nextbit_blog_btn', 'View Product' );
                    }
                    $nextbit_blog_btn_switch = get_theme_mod( 'nextbit_blog_btn_switch', true );
                if ( !empty( $nextbit_blog_btn_switch ) ): ?>
                <a class="theme-btn btn-style-four" href="<?php the_permalink();?>">
                    <span class="txt"><?php print esc_html( $nextbit_blog_btn );?> <i class="lnr lnr-arrow-right"></i></span>
                </a>
                <?php endif; ?>
                <?php endif; ?>

            </div>
        </div>
    </article>
<?php
endif;?>
