<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package nextbit
 */

get_header();

$blog_column = is_active_sidebar( 'blog-sidebar' ) ? 'content-side col-lg-8 col-md-12 col-sm-12' : 'content-side col-lg-12 col-md-12 col-sm-12';
?>

<section class="sidebar-page-container nextbit-blog-page">
    <div class="auto-container">
        <div class="row clearfix">
			<div class="<?php print esc_attr( $blog_column ); ?>">
				<div class="blog-classic">
					<?php
						if ( have_posts() ):
    					if ( is_home() && !is_front_page() ):
    				?>
					<header>
						<h1 class="page-title screen-reader-text"><?php single_post_title();?></h1>
					</header>
					<?php
						endif;?>
						<div class="article_wrapper">
							<?php
								/* Start the Loop */
								while ( have_posts() ): the_post(); ?>
							<?php
								get_template_part( 'post-formats/content', get_post_format() );?>
							<?php endwhile; ?>
						</div>

						<div class="pagination_wrap">
							<?php nextbit_pagination( '<i class="far fa-angle-left"></i>', '<i class="far fa-angle-right"></i>', '', ['class' => ''] );?>
						</div>
						<?php
						else:
							get_template_part( 'post-formats/content', 'none' );
						endif;
					?>

				</div>
			</div>

			<?php if ( is_active_sidebar( 'blog-sidebar' ) ): ?>
		        <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
					<aside class="sidebar sticky-top">
						<?php get_sidebar();?>
	            	</aside>
	            </div>
			<?php endif;?>
        </div>
    </div>
</section>

<?php
get_footer();
