<?php
/**
 * [nextbit_remove_hook description]
 * @return [type] [description]
 */
function nextbit_remove_hook() {
    remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
    remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
    remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
    remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
    remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
    remove_action('woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20);
    remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
    add_action('nextbit_before_shop_loop_item_thumb', 'woocommerce_template_loop_product_link_open', 10);

    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10 );
    remove_action( 'woocommerce_before_shop_loop', 'nextbit_woo_notice', 10 );

    remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
    add_action('woocommerce_sidebar', 'nextbit_woocommerce_get_sidebar', 10);

    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
    remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
    add_action('woocommerce_single_product_summary', 'nextbit_woo_rating', 5);
    add_action('woocommerce_mid_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 5);
    add_action('woocommerce_after_shop_loop_item_title', 'nextbit_product_cart_button', 15);
    add_action('nextbit_woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20);

    remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
    add_action('woocommerce_after_shop_loop_item_title', 'nextbit_woocommerce_template_loop_price', 10);

    add_filter('woocommerce_sale_flash', 'woocommerce_custom_sale_text', 10, 3);

    remove_action('yith_wcqv_product_image', 'woocommerce_show_product_sale_flash', 10);
    remove_action('yith_wcqv_product_image', 'woocommerce_show_product_images', 20);
    remove_action('yith_wcqv_product_summary', 'woocommerce_template_single_rating', 10);
    add_action('yith_wcqv_product_image', 'nextbit_quick_view_images', 21);
    add_action('yith_wcqv_product_summary', 'nextbit_woo_rating', 10);
}

nextbit_remove_hook();

add_filter('woocommerce_show_page_title', function () {
    return false;
});

/**
 * [nextbit_product_title description]
 * @return [type] [description]
 */
function nextbit_product_title() {
    print '<a href="' . get_the_permalink() . '" class="name">' . get_the_title() . '</a>';
}

/**
 * [nextbit_product_cart_button description]
 * @return [type] [description]
 */
function here() {
    echo 'kuire';
}
function nextbit_product_cart_button()
{
    global $product;
    $class = 'cart product_type_' . $product->get_type() . ' add_to_cart_button ' . ($product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '');
    $attributes = array(
        'data-product_id' => $product->get_id(),
        'data-product_sku' => $product->get_sku(),
        'aria-label' => $product->add_to_cart_description(),
        'rel' => 'nofollow',
    );
    print '<ul class="shop-options">';
    print '<li>
                <a data-product_id="'.$product->get_id().'" data-product_sku="'.$product->get_sku().'" aria-label="'.$product->add_to_cart_description().'" rel="nofollow" class="' . $class . '" href="' . $product->add_to_cart_url() . '"> '.esc_html__('Add to Cart', 'nextbit').'</a>
            </li>';
    print '<li>'.nextbit_vc_yith_wishlist().'</li>';
    print '<li>'.nextbit_quick_view_button($product->get_id()).'</li>';
    print '</ul>';
}

/**
 * [nextbit_product_cart_button description]
 * @return [type] [description]
 */
function woocommerce_custom_sale_text($text, $post, $_product) {
    return '<div class="item_label">Sale</div>';
}

function nextbit_woo_category() {
    global $product;
    $current_cats = get_the_terms( get_the_ID(), 'product_cat' );
    //only start if we have some tags
    if ( $current_cats && ! is_wp_error( $current_cats ) ) {

    //create a list to hold our tags
    echo '<ul class="item_category_list ul_li pl-0">';

    //for each tag we create a list item
    foreach ($current_cats as $cat) {

        $cat_title = $cat->name; // tag name
        $cat_link = get_term_link( $cat );// tag archive link

        echo '<li><a href="'.$cat_link.'">'.$cat_title.' </a></li>';
    }

    echo '</ul>';
    }
}


/**
 * [nextbit_woo_rating description]
 * @return [type] [description]
 */
function nextbit_woo_rating()
{
    global $product;
    $rating = $product->get_average_rating();
    $rating_count = $product->get_review_count();
    $review = ''.esc_html__('Rating', 'nextbit').' ' . $rating . ' '.esc_html__('out of 5', 'nextbit').'';
    $html = '';
    $html .= '<div class="rating" title="' . $review . '">';
    for ($i = 0; $i <= 4; $i++) {
        if ($i < floor($rating)) {
            $html .= '<span class="fas fa-star"></span>';
        } else {
            $html .= '<span class="far fa-star"></span>';
        }
    }
    $html .= '<a href="#"> ' . $rating_count . ' Reviews</a>';
    $html .= '</div>';
    print nextbit_woo_rating_html($html);
}

function nextbit_woo_rating_html($html)
{
    return $html;
}

/**
 * [nextbit_woo_rating description]
 * @return [type] [description]
 */
function nextbit_woo_shop_rating()
{
    global $product;
    $rating = $product->get_average_rating();
    $review = esc_html('Rating ' . $rating . ' out of 5');
    ob_start(); ?>
    <div class="rating mb-10" title="<?php print esc_attr($review); ?>">
        <?php
        for ($i = 0; $i <= 4; $i++) {
            if ($i < floor($rating)) { ?>
                <a href="#"><i class="fas fa-star"></i></a>
                <?php
            } else { ?>
                <a href="#"><i class="far fa-star"></i></a>
                <?php
            }
        }
        ?>
    </div>
    <?php
    return ob_get_clean();
}

function nextbit_get_price()
{
    ob_start(); ?>
    <div class="price"><?php print nextbit_get_price_html(); ?></div>
    <?php
    return ob_get_clean();
}

function nextbit_get_price_html()
{
    global $product;
    return $product->get_price_html();
}

/**
 * [nextbit_comment_rating description]
 * @param  [type] $rating [description]
 * @return [type]         [description]
 */
function nextbit_comment_rating($rating)
{
    $review = ''.esc_html__('Rating', 'nextbit').' ' . $rating . ' '.esc_html__('out of 5', 'nextbit').'';
    $html = '';
    $html .= '<div class="rating" title="' . $review . '">';
    for ($i = 0; $i <= 4; $i++) {
        if ($i < floor($rating)) {
            $html .= '<a href="#"><i class="fas fa-star"></i></a>';
        } else {
            $html .= '<a href="#"><i class="far fa-star"></i></a>';
        }
    }
    $html .= '</div>';
    return $html;
}


add_filter('add_to_cart_fragments', 'nextbit_woocommerce_header_add_to_cart_fragment');

/**
 * [nextbit_woocommerce_header_add_to_cart_fragment description]
 * @param  [type] $fragments [description]
 * @return [type]            [description]
 */
function nextbit_woocommerce_header_add_to_cart_fragment($fragments)
{
    global $woocommerce;
    ob_start();
    ?>
    <a class="cp-minicart" href="<?php print wc_get_cart_url(); ?>"><i class="fas fa-shopping-cart"></i><span
                id="nextbit-cart"
                class="mini-cart-items"><?php print WC()->cart->get_cart_contents_count(); ?></span></a>
    <?php
    $fragments['a.cp-minicart'] = ob_get_clean();
    return $fragments;
}

function nextbit_vc_yith_wishlist($style = 1)
{

    global $product;

    $cssclass = 'wishlist-rd';
    $mar = 'tanzim-mar-top';

    if ($style != 2) {
        $cssclass = 'pro-btn';
        $mar = '';
    }

    $id = $product->get_id();
    $type = $product->get_type();
    $link = get_site_url();

    $img = '<img src="' . esc_attr($link) . '/wp-content/plugins/yith-woocommerce-quick-view/assets/image/qv-loader.gif" class="ajax-loading" alt="' . esc_attr__('loading', 'nextbit') . '">';
    $markup = '';

    if (NEXTBIT_WISHLIST_ACTIVED) {

        $markup .= '<div class="yith-wcwl-add-to-wishlist ' . $mar . ' add-to-wishlist-' . $id . '">';
        $markup .= '<div class="yith-wcwl-add-button wishlist show" style="display:block">';
        $markup .= '<a href="' . $link . '/shop/?add_to_wishlist=' . $id . '" rel="nofollow" data-product-id="' . $id . '" data-product-type="' . $type . '" class="add_to_wishlist ' . $cssclass . '">';
        $markup .= '<i class="yith-wcwl-icon far fa-heart"></i></a>';
        $markup .= $img;
        $markup .= '</div>';
        $markup .= '<div class="yith-wcwl-wishlistaddedbrowse wishlist hide" style="display:none;">';
        $markup .= '<a href="' . $link . '/wishlist/view/" rel="nofollow" class=" ' . $cssclass . '"><i class="yith-wcwl-icon fa fa-heart"></i></a>';
        $markup .= $img;
        $markup .= '</div>';
        $markup .= '<div class="yith-wcwl-wishlistexistsbrowse wishlist hide" style="display:none">';
        $markup .= '<a href="' . $link . '/wishlist/view/" rel="nofollow" class=" ' . $cssclass . '"><i class="far fa-heart"></i></a>';
        $markup .= $img;
        $markup .= '</div>';
        $markup .= '<div style="clear:both"></div>';
        $markup .= '<div class="yith-wcwl-wishlistaddresponse"></div>';
        $markup .= '</div>';
    }

    return $markup;
}

add_filter('woocommerce_product_additional_information_heading', 'nextbit_tab_heading');
add_filter('woocommerce_product_description_heading', 'nextbit_tab_heading');

/**
 * [nextbit_tab_heading description]
 * @param  [type] $heading [description]
 * @return [type]          [description]
 */
function nextbit_tab_heading($heading)
{
    return '';
}

/**
 * [nextbit_woo_pagination description]
 * @param  [type] $pagination [description]
 * @return [type]             [description]
 */
function nextbit_woo_pagination($pagination)
{
    $pagi = '';
    if ($pagination != '') {
        $pagi .= '<ul class="styled-pagination text-center">';
        foreach ($pagination as $key => $pg) {
            $pagi .= '<li class="page-item">' . $pg . '</li>';
        }
        $pagi .= '</ul>';
    }
    return $pagi;
}

function nextbit_woocommerce_get_sidebar()
{
    dynamic_sidebar('product-sidebar');
}

function nextbit_woocommerce_template_loop_price() {
    print '<div class="lower-content">';
    nextbit_product_title();
    print nextbit_get_price();
    print '</div>';
}

function nextbit_woocommerce_template_single_price()
{
    print '<div class="price mt-15 mb-20">';
    print nextbit_get_price_html();
    print '</div>';
}

function woocommerce_template_single_stock()
{
    global $product;
    if ($product->get_stock_quantity() > 0) {
        print '<div class="cart-title">';
        print '<h6>Availability: <span>'.esc_html__('Quick View', 'nextbit').'</span></h6>';
        print '</div>';
    } else {
        if ($product->backorders_allowed()) {
            print '<div class="cart-title">';
            print '<h6>Availability: <span>On Backorder '.esc_html__('Quick View', 'nextbit').'</span></h6>';
            print '</div>';
        } else {
            print '<div class="cart-title">';
            print '<h6>Availability: <span>Out of stock '.esc_html__('Quick View', 'nextbit').'</span></h6>';
            print '</div>';
        }
    }
}

if (!function_exists('nextbit_header_cart_count')) {
    function nextbit_header_cart_count($fragments)
    {
        ob_start();
        ?>
        <span class="total-cart" id="nextbit-cart-count">
			<?php print esc_html(WC()->cart->cart_contents_count); ?>
		</span>
        <?php
        $fragments['.total-cart'] = ob_get_clean();
        return $fragments;
    }
}
add_filter('woocommerce_add_to_cart_fragments', 'nextbit_header_cart_count');

if (!function_exists('nextbit_header_cart_price')) {
    function nextbit_header_cart_price($fragments)
    {
        ob_start();
        ?>
        <span class="cart__amount" id="nextbit-total-price">
			<?php print WC()->cart->get_cart_total(); ?>
		</span>
        <?php
        $fragments['#nextbit-total-price'] = ob_get_clean();
        return $fragments;
    }
}
add_filter('woocommerce_add_to_cart_fragments', 'nextbit_header_cart_price');

/**
 * @param $product_id
 * @return mixed|string|void
 */
function nextbit_quick_view_button($product_id)
{
    if (NEXTBIT_QUICK_VIEW_ACTIVED) {
        $product = wc_get_product($product_id);
        $button = '';
        if ($product_id) {

            $button = '<a href="#" class="yith-wcqv-button" data-product_id="' . esc_attr($product_id) . '" data-toggle="tooltip" data-placement="top" title="'.esc_attr__('Quick View', 'nextbit').'"><i class="fal fa-eye"></i></a>';
            $button = apply_filters('yith_add_quick_view_button_html', $button, '', $product);
        }
        return $button;
    }
}

if (!function_exists('nextbit_quick_view_images')) {
    function nextbit_quick_view_images()
    { ?>
        <div class="nextbit-quick-view-images">
            <?php wc_get_template('single-product/product-image.php');
            ?>
        </div>
        <?php
    }
}

add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {

    ob_start();
    ?>
    <div class="header-mini-cart">
        <?php woocommerce_mini_cart(); ?>
    </div>
    <?php $fragments['.header-mini-cart'] = ob_get_clean();
    return $fragments;

});

if (NEXTBIT_WISHLIST_ACTIVED && !function_exists('yith_wishlist_ajax_update_count')) {
    function yith_wishlist_ajax_update_count()
    {
        wp_send_json(array(
            'count' => yith_wcwl_count_all_products()
        ));
    }

    add_action('wp_ajax_yith_wcwl_update_wishlist_count', 'yith_wishlist_ajax_update_count');
    add_action('wp_ajax_nopriv_yith_wcwl_update_wishlist_count', 'yith_wishlist_ajax_update_count');
}

if (NEXTBIT_WISHLIST_ACTIVED && !function_exists('yith_wishlist_ajax_script')) {
    function yith_wishlist_ajax_script()
    {
        wp_add_inline_script(
            'jquery-yith-wcwl',
            "
                jQuery( function( $ ) {
                  $( document ).on( 'added_to_wishlist removed_from_wishlist', function() {
                    $.get( yith_wcwl_l10n.ajax_url, {
                      action: 'yith_wcwl_update_wishlist_count'
                    }, function( data ) {
                      $('.yith-wcwl-items-count').html( data.count );
                    } );
                  } );
                } );
            "
        );
    }

    add_action('wp_enqueue_scripts', 'yith_wishlist_ajax_script', 20);
}
