<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package nextbit
 */

/**
 *
 * nextbit header
 */

function nextbit_check_header() {
    $nextbit_header_style = function_exists( 'get_field' ) ? get_field( 'header_style' ) : NULL;
    $nextbit_default_header_style = get_theme_mod( 'choose_default_header', 'header-style-1' );

    if ( $nextbit_header_style == 'header-style-1' ) {
        nextbit_header_style_1();
    } elseif ( $nextbit_header_style == 'header-style-2' ) {
        nextbit_header_style_2();
    }elseif ( $nextbit_header_style == 'header-style-3' ){
        nextbit_header_style_3();
    }elseif ( $nextbit_header_style == 'header-style-4' ){
        nextbit_header_style_4();
    }elseif ( $nextbit_header_style == 'header-style-5' ){
        nextbit_header_style_5();
    }elseif ( $nextbit_header_style == 'header-style-6' ){
        nextbit_header_style_6();
    }elseif ($nextbit_header_style == 'header-style-7' ) {
        nextbit_header_style_7();
    }elseif ($nextbit_header_style == 'header-style-8' ) {
        nextbit_header_style_8();
    }else {

        /** default header style **/
        if ( $nextbit_default_header_style == 'header-style-2' ) {
            nextbit_header_style_2();
        }elseif($nextbit_default_header_style == 'header-style-3'){
            nextbit_header_style_3();
        }elseif($nextbit_default_header_style == 'header-style-4'){
            nextbit_header_style_4();
        }elseif($nextbit_default_header_style == 'header-style-4'){
            nextbit_header_style_5();
        }elseif($nextbit_default_header_style == 'header-style-4'){
            nextbit_header_style_6();
        }elseif($nextbit_default_header_style == 'header-style-7'){
            nextbit_header_style_7();
        }elseif($nextbit_default_header_style == 'header-style-8'){
            nextbit_header_style_8();
        }else {
            nextbit_header_style_1();
        }

    }

}
add_action( 'nextbit_header_style', 'nextbit_check_header', 10 );

/**
 * Implement the Custom Header feature.
 */
require NEXTBIT_THEME_DIR . '/inc/header/header-1.php';
require NEXTBIT_THEME_DIR . '/inc/header/header-2.php';
require NEXTBIT_THEME_DIR . '/inc/header/header-3.php';
require NEXTBIT_THEME_DIR . '/inc/header/header-4.php';
require NEXTBIT_THEME_DIR . '/inc/header/header-5.php';
require NEXTBIT_THEME_DIR . '/inc/header/header-6.php';
require NEXTBIT_THEME_DIR . '/inc/header/header-7.php';
require NEXTBIT_THEME_DIR . '/inc/header/header-8.php';




// nextbit_side_info
function nextbit_side_info() {

    $nextbit_side_hide = get_theme_mod( 'nextbit_side_hide', false );
    $nextbit_extra_about_title = get_theme_mod( 'nextbit_extra_about_title', __( 'About Us', 'nextbit' ) );
    $nextbit_extra_about_text = get_theme_mod( 'nextbit_extra_about_text', __( 'Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armou like back and if he lifted his head a little he could see his brown belly', 'nextbit' ) );
    $nextbit_extra_button = get_theme_mod( 'nextbit_extra_button', __( 'Consultation', 'nextbit' ) );
    $nextbit_extra_button_url = get_theme_mod( 'nextbit_extra_button_url', __( '#', 'nextbit' ) );
    $nextbit_contact_title = get_theme_mod( 'nextbit_contact_title', __( 'FOLLOW US', 'nextbit' ) );
    $nextbit_extra_address = get_theme_mod( 'nextbit_extra_address', __( 'Bowery St., New York, NY 10013, USA', 'nextbit' ) );
    $nextbit_extra_phone = get_theme_mod( 'nextbit_extra_phone', __( '+1255-568-6523', 'nextbit' ) );
    $nextbit_extra_email = get_theme_mod( 'nextbit_extra_email', __( 'information@gmail.com', 'nextbit' ) );
    $nextbit_extra_hour = get_theme_mod( 'nextbit_extra_hour', __( 'Week Days: 09.00 to 18.00 Sunday: Closed', 'nextbit' ) );

    ?>
    <!-- more info sidebar - start
    ================================================== -->
    <div class="xs-sidebar-group info-group">
		<div class="xs-overlay xs-bg-black"></div>
		<div class="xs-sidebar-widget">
			<div class="sidebar-widget-container">
				<div class="widget-heading">
					<a href="#" class="close-side-widget"><i class="fal fa-times"></i></a>
				</div>
				<div class="sidebar-textwidget">

					<!-- Sidebar Info Content -->
					<div class="sidebar-info-contents">
						<div class="content-inner">
							<div class="logo">
								<?php nextbit_header_side_logo(); ?>
							</div>
							<div class="content-box">

                                <?php if(!empty( $nextbit_extra_about_title )) : ?>
								<h5><?php print esc_html($nextbit_extra_about_title); ?></h5>
                                <?php endif; ?>

                                <?php if(!empty( $nextbit_extra_about_text )) : ?>
								<p class="text"><?php print esc_html($nextbit_extra_about_text); ?></p>
                                <?php endif; ?>

                                <?php if(!empty( $nextbit_extra_button )) : ?>
								<a href="<?php print esc_url($nextbit_extra_button_url); ?>" class="theme-btn btn-style-one">
                                <span class="txt"><?php print esc_html($nextbit_extra_button); ?></span></a>
                                <?php endif; ?>

							</div>
							<div class="contact-info">

                                <?php if(!empty( $nextbit_contact_title )) : ?>
								<h5><?php print esc_html($nextbit_contact_title); ?></h5>
                                <?php endif; ?>

								<ul class="list-style-one">

                                    <?php if(!empty( $nextbit_extra_address )) : ?>
									<li><span class="icon fa fa-location-arrow"></span><?php echo esc_html($nextbit_extra_address); ?></li>
                                    <?php endif; ?>

                                    <?php if(!empty( $nextbit_extra_phone )) : ?>
									<li><span class="icon fa fa-phone"></span><?php echo esc_html($nextbit_extra_phone); ?></li>
                                    <?php endif; ?>

                                    <?php if(!empty( $nextbit_extra_email )) : ?>
									<li><span class="icon fa fa-envelope"></span><?php echo esc_html($nextbit_extra_email); ?></li>
                                    <?php endif; ?>

                                    <?php if(!empty( $nextbit_extra_hour )) : ?>
									<li><span class="icon fa fa-clock-o"></span><?php echo esc_html($nextbit_extra_hour); ?></li>
                                    <?php endif; ?>
								</ul>
							</div>
							<!-- Social Box -->
							<?php nextbit_header_social_profiles(); ?>
						</div>
					</div>

				</div>
			</div>
		</div>
	</div>
    <!-- more info sidebar - end
    ================================================== -->

<?php }

/**
 * [nextbit_header_lang description]
 * @return [type] [description]
 */
function nextbit_header_lang_defualt() {
    $nextbit_header_lang = get_theme_mod( 'nextbit_header_lang', false );
    if ( $nextbit_header_lang ): ?>

    <ul>
        <li><a href="#0" class="lang__btn"><?php print __( 'English', 'nextbit' );?> <i class="ti-arrow-down"></i></a>
        <?php do_action( 'nextbit_language' );?>
        </li>
    </ul>

    <?php endif;?>
<?php
}

/**
 * [nextbit_language_list description]
 * @return [type] [description]
 */
function nextbit_language( $mar ) {
    return $mar;
}
function nextbit_language_list() {

    $mar = '';
    $languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=id&order=desc' );
    if ( !empty( $languages ) ) {
        $mar = '<ul class="lang-list">';
        foreach ( $languages as $lan ) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<li class="' . $active . '"><a href="' . $lan['url'] . '">' . $lan['translated_name'] . '</a></li>';
        }
        $mar .= '</ul>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<ul class="lang-sub-list">';
        $mar .= '<li><a href="#">' . __( 'Bangla', 'nextbit' ) . '</a></li>';
        $mar .= '<li><a href="#">' . __( 'Arabic', 'nextbit' ) . '</a></li>';
        $mar .= ' </ul>';
    }
    print nextbit_language( $mar );
}
add_action( 'nextbit_language', 'nextbit_language_list' );

// favicon logo
function nextbit_favicon_logo_func() {
        $nextbit_favicon = get_template_directory_uri() . '/assets/images/favicon.ico';
        $nextbit_favicon_url = get_theme_mod( 'favicon_url', $nextbit_favicon );
    ?>

    <link rel="shortcut icon" type="image/x-icon" href="<?php print esc_url( $nextbit_favicon_url );?>">

    <?php
}
add_action( 'wp_head', 'nextbit_favicon_logo_func' );

// header logo
function nextbit_header_logo() {
    ?>
    <?php
        $nextbit_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $nextbit_logo = get_template_directory_uri() . '/assets/images/logo.svg';
        $nextbit_logo_white = get_template_directory_uri() . '/assets/images/logo-2.svg';

        $nextbit_site_logo = get_theme_mod( 'logo', $nextbit_logo );
        $nextbit_secondary_logo = get_theme_mod( 'seconday_logo', $nextbit_logo_white );
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $nextbit_logo_on ) ) {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_secondary_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_site_logo );?>" srcset="<?php print esc_url( $nextbit_site_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}

// header logo
function nextbit_header_light_logo() {
    ?>
    <?php
        $nextbit_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $nextbit_logo_white = get_template_directory_uri() . '/assets/images/logo-2.svg';
        $nextbit_secondary_logo = get_theme_mod( 'seconday_logo', $nextbit_logo_white );
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $nextbit_logo_on ) ) {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_secondary_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_secondary_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}

// header logo
function nextbit_header_light2_logo() {
    ?>
    <?php
        $nextbit_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $nextbit_logo2_white = get_template_directory_uri() . '/assets/images/logo-3.png';
        $nextbit_third_logo = get_theme_mod( 'third_logo', $nextbit_logo2_white );
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $nextbit_logo_on ) ) {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_third_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_third_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}

// header logo
function nextbit_header_light3_logo() {
    ?>
    <?php
        $nextbit_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $nextbit_logo3_white = get_template_directory_uri() . '/assets/images/logo-7.png';
        $nextbit_third_logo = get_theme_mod( 'forth_logo', $nextbit_logo3_white );
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $nextbit_logo_on ) ) {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_third_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_third_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}

// header logo
function nextbit_header_logo_4() {
    ?>
    <?php
        $nextbit_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $nextbit_logo4_white = get_template_directory_uri() . '/assets/images/logo-9.png';
        $nextbit_seven_logo = get_theme_mod( 'seven_logo', $nextbit_logo4_white );
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $nextbit_logo_on ) ) {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_seven_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_seven_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}
// header logo
function nextbit_header_logo_5() {
    ?>
    <?php
        $nextbit_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $nextbit_logo5_white = get_template_directory_uri() . '/assets/images/logo-10.png';
        $nextbit_logo5_dark = get_template_directory_uri() . '/assets/images/logo-10-dark.png';
        $nextbit_eight_logo = get_theme_mod( 'eight_logo', $nextbit_logo5_white );
        $nextbit_eight_logo_dark = get_theme_mod( 'seven_logo_dark', $nextbit_logo5_dark );
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $nextbit_logo_on ) ) {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_eight_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                            <img src="<?php print esc_url( $nextbit_eight_logo_dark );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $nextbit_eight_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                            <img src="<?php print esc_url( $nextbit_eight_logo_dark );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}

// header logo
function nextbit_homsix_logo() {
    ?>
    <?php
        $nextbit_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $nextbit_logosix = get_template_directory_uri() . '/assets/images/logo-4.png';
        $forth_six_logo = get_theme_mod( 'forth_six_logo', $nextbit_logosix );
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $nextbit_logo_on ) ) {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $forth_six_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $forth_six_logo );?>" srcset="<?php print esc_url( $nextbit_secondary_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}

// header logo
function nextbit_header_side_logo() {
    ?>
    <?php
        $nextbit_side_logo = get_theme_mod('nextbit_side_logo', get_template_directory_uri() . '/assets/images/logo-2.svg');
    ?>

    <?php
        if ( has_custom_logo() ) {
            the_custom_logo();
        } else {
        ?>
        <a href="<?php print esc_url( home_url( '/' ) );?>"><img src="<?php print esc_url( $nextbit_side_logo );?>" alt="<?php echo esc_attr__('logo', 'nextbit'); ?>" /></a>
        <?php

        }
    ?>
    <?php
}

// header logo
function nextbit_header_sticky_logo() {
    ?>
    <?php
        $nextbit_logo = get_template_directory_uri() . '/assets/images/logo/logo.svg';
        $nextbit_site_logo = get_theme_mod( 'logo_sticky', $nextbit_logo );
    ?>

    <?php
        if ( has_custom_logo() ) {
            the_custom_logo();
        } else {
        ?>
            <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                <img src="<?php print esc_url( $nextbit_site_logo );?>" srcset="<?php print esc_url( $nextbit_site_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
            </a>
        <?php

        }
    ?>
    <?php
}

// header logo
function nextbit_header_sticky2_logo() {
    ?>
    <?php
        $nextbit_logo = get_template_directory_uri() . '/assets/images/logo-8.png';
        $nextbit_site_logo = get_theme_mod( 'forth_blue_logo', $nextbit_logo );
    ?>

    <?php
        if ( has_custom_logo() ) {
            the_custom_logo();
        } else {
        ?>
            <a class="brand_link" href="<?php print esc_url( home_url( '/' ) );?>">
                <img src="<?php print esc_url( $nextbit_site_logo );?>" srcset="<?php print esc_url( $nextbit_site_logo );?>" alt="<?php print esc_attr__( 'logo_not_found', 'nextbit' );?>">
            </a>
        <?php

        }
    ?>
    <?php
}

function nextbit_mobile_logo() {
    // side info
    $nextbit_mobile_logo_hide = get_theme_mod( 'nextbit_mobile_logo_hide', false );

    $nextbit_site_logo = get_theme_mod( 'logo', get_template_directory_uri() . '/assets/images/logo/logo.svg' );

    ?>

    <?php if ( !empty( $nextbit_mobile_logo_hide ) ): ?>
    <div class="side__logo mb-25">
        <a class="sideinfo-logo" href="<?php print esc_url( home_url( '/' ) );?>">
            <img src="<?php print esc_url( $nextbit_site_logo );?>" alt="<?php print esc_attr__( 'logo', 'nextbit' );?>" />
        </a>
    </div>
    <?php endif;?>



<?php }

/**
 * [nextbit_header_social_profiles description]
 * @return [type] [description]
 */
function nextbit_header_social_profiles() {
    $nextbit_topbar_fb_url = get_theme_mod( 'nextbit_topbar_fb_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_twitter_url = get_theme_mod( 'nextbit_topbar_twitter_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_google_url = get_theme_mod( 'nextbit_topbar_google_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_instagram_url = get_theme_mod( 'nextbit_topbar_instagram_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_linkedin_url = get_theme_mod( 'nextbit_topbar_linkedin_url', __( '', 'nextbit' ) );
    $nextbit_topbar_youtube_url = get_theme_mod( 'nextbit_topbar_youtube_url', __( '', 'nextbit' ) );
    ?>

    <ul class="social-box">
        <?php if ( !empty( $nextbit_topbar_fb_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_topbar_fb_url );?>"><i class="fab fa-facebook-f"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_topbar_twitter_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_topbar_twitter_url );?>"><i class="fab fa-twitter"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_topbar_google_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_topbar_google_url );?>"><i class="fab fa-google-plus-g"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_topbar_instagram_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_topbar_instagram_url );?>"><i class="fab fa-instagram"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_topbar_linkedin_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_topbar_linkedin_url );?>"><span><i class="fab fa-linkedin"></i></span></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_topbar_youtube_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_topbar_youtube_url );?>"><span><i class="fab fa-youtube"></i></span></a></li>
        <?php endif;?>
    </ul>
<?php
}
/**
 * [nextbit_header_social_profiles description]
 * @return [type] [description]
 */
function nextbit_header_social_profiles_2() {
    $nextbit_topbar_fb_url = get_theme_mod( 'nextbit_topbar_fb_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_twitter_url = get_theme_mod( 'nextbit_topbar_twitter_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_google_url = get_theme_mod( 'nextbit_topbar_google_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_instagram_url = get_theme_mod( 'nextbit_topbar_instagram_url', __( '#', 'nextbit' ) );
    $nextbit_topbar_linkedin_url = get_theme_mod( 'nextbit_topbar_linkedin_url', __( '', 'nextbit' ) );
    $nextbit_topbar_youtube_url = get_theme_mod( 'nextbit_topbar_youtube_url', __( '', 'nextbit' ) );
    ?>

    <div class="social-links social-links--2 ml-30 text-center text-md-right">
        <?php if ( !empty( $nextbit_topbar_fb_url ) ): ?>
        <a target="_blank" href="<?php print esc_url( $nextbit_topbar_fb_url );?>">
            <i class="fab fa-facebook-f"></i>
            <i class="fab fa-facebook-f"></i>
        </a>
        <?php endif;?>

        <?php if ( !empty( $nextbit_topbar_twitter_url ) ): ?>
        <a target="_blank" href="<?php print esc_url( $nextbit_topbar_twitter_url );?>">
            <i class="fab fa-twitter"></i>
            <i class="fab fa-twitter"></i>
        </a>
        <?php endif;?>
        
        <?php if ( !empty( $nextbit_topbar_google_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_topbar_google_url );?>">
                <i class="fab fa-google-plus-g"></i>
                <i class="fab fa-google-plus-g"></i>
            </a>
        <?php endif;?>

        <?php if ( !empty( $nextbit_topbar_instagram_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_topbar_instagram_url );?>">
                <i class="fab fa-instagram"></i>
                <i class="fab fa-instagram"></i>
            </a>  
        <?php endif;?>

        <?php if ( !empty( $nextbit_topbar_linkedin_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_topbar_linkedin_url );?>">
                <i class="fab fa-linkedin"></i>
                <i class="fab fa-linkedin"></i>
            </a>
        <?php endif;?>

        <?php if ( !empty( $nextbit_topbar_youtube_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_topbar_youtube_url );?>">
                <i class="fab fa-youtube"></i>
                <i class="fab fa-youtube"></i>
            </a>
        <?php endif;?>
    </div>
<?php
}



function nextbit_footer_social_profiles() {
    $nextbit_footer_fb_url = get_theme_mod( 'nextbit_footer_fb_url', __( '#', 'nextbit' ) );
    $nextbit_footer_twitter_url = get_theme_mod( 'nextbit_footer_twitter_url', __( '#', 'nextbit' ) );
    $nextbit_footer_google_url = get_theme_mod( 'nextbit_footer_google_url', __( '#', 'nextbit' ) );
    $nextbit_footer_instagram_url = get_theme_mod( 'nextbit_footer_instagram_url', __( '#', 'nextbit' ) );
    $nextbit_footer_linkedin_url = get_theme_mod( 'nextbit_footer_linkedin_url', __( '', 'nextbit' ) );
    $nextbit_footer_youtube_url = get_theme_mod( 'nextbit_footer_youtube_url', __( '', 'nextbit' ) );
?>

    <ul class="social-box">
        <?php if ( !empty( $nextbit_footer_fb_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_footer_fb_url );?>"><i class="fab fa-facebook-f"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_footer_twitter_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_footer_twitter_url );?>"><i class="fab fa-twitter"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_footer_google_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_footer_google_url );?>"><i class="fab fa-google-plus-g"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_footer_instagram_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_footer_instagram_url );?>"><i class="fab fa-instagram"></i></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_footer_linkedin_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_footer_linkedin_url );?>"><span><i class="fab fa-linkedin"></i></span></a></li>
        <?php endif;?>
        <?php if ( !empty( $nextbit_footer_youtube_url ) ): ?>
        <li><a target="_blank" href="<?php print esc_url( $nextbit_footer_youtube_url );?>"><span><i class="fab fa-youtube"></i></span></a></li>
        <?php endif;?>
    </ul>
<?php
}

/**
 * [nextbit_footer_social_profiles description]
 * @return [type] [description]
 */
function nextbit_footer_social_profiles_2() {
    $nextbit_footer_fb_url = get_theme_mod( 'nextbit_footer_fb_url', __( '#', 'nextbit' ) );
    $nextbit_footer_twitter_url = get_theme_mod( 'nextbit_footer_twitter_url', __( '#', 'nextbit' ) );
    $nextbit_footer_google_url = get_theme_mod( 'nextbit_footer_google_url', __( '#', 'nextbit' ) );
    $nextbit_footer_instagram_url = get_theme_mod( 'nextbit_footer_instagram_url', __( '#', 'nextbit' ) );
    $nextbit_footer_linkedin_url = get_theme_mod( 'nextbit_footer_linkedin_url', __( '', 'nextbit' ) );
    $nextbit_footer_youtube_url = get_theme_mod( 'nextbit_footer_youtube_url', __( '', 'nextbit' ) );
    ?>

    <div class="social-links text-center text-md-right">
        <?php if ( !empty( $nextbit_footer_fb_url ) ): ?>
        <a target="_blank" href="<?php print esc_url( $nextbit_footer_fb_url );?>">
            <i class="fab fa-facebook-f"></i>
            <i class="fab fa-facebook-f"></i>
        </a>
        <?php endif;?>

        <?php if ( !empty( $nextbit_footer_twitter_url ) ): ?>
        <a target="_blank" href="<?php print esc_url( $nextbit_footer_twitter_url );?>">
            <i class="fab fa-twitter"></i>
            <i class="fab fa-twitter"></i>
        </a>
        <?php endif;?>
        
        <?php if ( !empty( $nextbit_footer_google_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_footer_google_url );?>">
                <i class="fab fa-google-plus-g"></i>
                <i class="fab fa-google-plus-g"></i>
            </a>
        <?php endif;?>

        <?php if ( !empty( $nextbit_footer_instagram_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_footer_instagram_url );?>">
                <i class="fab fa-instagram"></i>
                <i class="fab fa-instagram"></i>
            </a>  
        <?php endif;?>

        <?php if ( !empty( $nextbit_footer_linkedin_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_footer_linkedin_url );?>">
                <i class="fab fa-linkedin"></i>
                <i class="fab fa-linkedin"></i>
            </a>
        <?php endif;?>

        <?php if ( !empty( $nextbit_footer_youtube_url ) ): ?>
            <a target="_blank" href="<?php print esc_url( $nextbit_footer_youtube_url );?>">
                <i class="fab fa-youtube"></i>
                <i class="fab fa-youtube"></i>
            </a>
        <?php endif;?>
    </div>
<?php
}

/**
 * [nextbit_header_menu description]
 * @return [type] [description]
 */
function nextbit_header_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => 'navigation clearfix',
            'container'      => '',
            'fallback_cb'    => 'Navwalker_Class::fallback',
            'walker'         => new Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [nextbit_header_menu description]
 * @return [type] [description]
 */
function nextbit_header_menu_7() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => 'main_menu_list ul_li',
            'container'      => '',
            'fallback_cb'    => 'Navwalker_Class::fallback',
            'walker'         => new Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [nextbit_header_menu description]
 * @return [type] [description]
 */

function nextbit_mobile_menu() {
    ?>
    <?php
        echo str_replace(['menu-item-has-children', 'submenu'], ['dropdown', 'sub-menu'], wp_nav_menu( [
            'echo' => false,
            'theme_location' => 'main-menu',
            'menu_id'     => 'mobile-menu-active',
            'container'      => '',
            'fallback_cb'    => 'Navwalker_Class::fallback',
            'walker'         => new Navwalker_Class,
        ] ));
    ?>
    <?php
}

/**
 * [nextbit_header_menu description]
 * @return [type] [description]
 */
//  Main Menu left (Header style 2)
 function nextbit_header_menu_left() {
    wp_nav_menu( [
        'theme_location' => 'main-menu-left',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Navwalker_Class::fallback',
        'walker'         => new Navwalker_Class,
    ] );
}

// Main Menu Right (Header style 2)
 function nextbit_header_menu_right() {
    wp_nav_menu( [
        'theme_location' => 'main-menu-right',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Navwalker_Class::fallback',
        'walker'         => new Navwalker_Class,
    ] );
}

/**
 * [nextbit_footer_menu description]
 * @return [type] [description]
 */

function nextbit_footer_menu_left() {
    wp_nav_menu( [
        'theme_location' => 'footer-menu-left',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Navwalker_Class::fallback',
        'walker'         => new Navwalker_Class,
    ] );
}

// Footer menu right
function nextbit_footer_menu_right() {
    wp_nav_menu( [
        'theme_location' => 'footer-menu-right',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Navwalker_Class::fallback',
        'walker'         => new Navwalker_Class,
    ] );
}

/**
 *
 * nextbit footer
 */
add_action( 'nextbit_footer_style', 'nextbit_check_footer', 10 );

function nextbit_check_footer() {
    $nextbit_footer_style = function_exists( 'get_field' ) ? get_field( 'footer_style' ) : NULL;
    $nextbit_default_footer_style = get_theme_mod( 'choose_default_footer', 'footer-style-1' );

    if ( $nextbit_footer_style == 'footer-style-1' ) {
        nextbit_footer_style_1();
    } elseif ( $nextbit_footer_style == 'footer-style-2' ) {
        nextbit_footer_style_2();
    } elseif ( $nextbit_footer_style == 'footer-style-3' ) {
        nextbit_footer_style_3();
    }elseif ( $nextbit_footer_style == 'footer-style-4' ) {
        nextbit_footer_style_4();
    }elseif ( $nextbit_footer_style == 'footer-style-5' ) {
        nextbit_footer_style_5();
    }elseif ($nextbit_footer_style == 'footer-style-6' ) {
        nextbit_footer_style_6();
    }else {

        /** default footer style **/
        if ( $nextbit_default_footer_style == 'footer-style-2' ) {
            nextbit_footer_style_2();
        } else {
            nextbit_footer_style_1();
        }

    }
}

/**
 * Implement the Custom Footer feature.
 */
require NEXTBIT_THEME_DIR . '/inc/footer/footer-1.php';
require NEXTBIT_THEME_DIR . '/inc/footer/footer-2.php';
require NEXTBIT_THEME_DIR . '/inc/footer/footer-3.php';
require NEXTBIT_THEME_DIR . '/inc/footer/footer-4.php';
require NEXTBIT_THEME_DIR . '/inc/footer/footer-5.php';
require NEXTBIT_THEME_DIR . '/inc/footer/footer-6.php';


// nextbit_copyright_text
function nextbit_copyright_text() {
    if ( rtl_enable() ) {
        print get_theme_mod( 'nextbit_copyright_rtl', __( '&copy; 2022 Your Company. All Rights Reserved. Designed By Themexriver', 'nextbit' ) );
    } else {
        print get_theme_mod( 'nextbit_copyright', __( '&copy; 2022 Your Company. All Rights Reserved. Designed By Themexriver', 'nextbit' ) );
    }
}

/**
 * [nextbit_breadcrumb description]
 * @return [type] [description]
 */
function nextbit_breadcrumb() {

    $wpbreadcrumb_class = '';
    $breadcrumb_show = 1;

    $id = get_the_ID();

    if ( is_front_page() && is_home() ) {
        $title = get_theme_mod( 'breadcrumb_blog_title', __( 'Blog', 'nextbit' ) );
        $wpbreadcrumb_class = 'home_front_page';
    } elseif ( is_front_page() ) {
        $title = get_theme_mod( 'breadcrumb_blog_title', __( 'Blog', 'nextbit' ) );
        $breadcrumb_show = 0;

    } elseif ( is_home() ) {
        if ( get_option( 'page_for_posts' ) ) {
            $id = get_option( 'page_for_posts' );
            $title = get_the_title( get_option( 'page_for_posts' ) );
        }
    } elseif ( is_single() && 'post' == get_post_type() ) {
        if ( rtl_enable() ) {
            $title = get_theme_mod( 'breadcrumb_blog_title_details_rtl', __( 'Blog Details', 'nextbit' ) );
        } else {
            $title = get_the_title();
        }
    } elseif ( is_search() ) {
        $title = __( 'Search Results for : ', 'nextbit' ) . get_search_query();
    } elseif ( is_404() ) {
        $title = __( 'Page not Found', 'nextbit' );
    } elseif ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
        $shop_page_id = wc_get_page_id( 'shop' );
        $page_title   = get_the_title( $shop_page_id );
        $title = apply_filters( 'woocommerce_page_title', $page_title );
    } elseif ( is_archive() ) {
        $title = get_the_archive_title();
    } else {
        $title = get_the_title();
    }

    $is_breadcrumb = function_exists( 'get_field' ) ? get_field( 'is_it_invisible_breadcrumb' ) : '';

    if ( empty( $is_breadcrumb ) && $breadcrumb_show == 1 ) {

        $bg_img_from_page = function_exists('get_field') ? get_field('breadcrumb_background_image', $id) : '';
        $hide_bg_img = function_exists('get_field') ? get_field('hide_breadcrumb_background_image', $id) : '';
        $breadcrumb_headline_from_page = function_exists( 'get_field' ) ? get_field( 'breadcrumb_headline', $id ) : '';

        // get_theme_mod
        $bg_img = get_theme_mod( 'breadcrumb_bg_img', '' );
        $bg_color = get_theme_mod( 'nextbit_breadcrumb_bg_color', '' );

        if ( $hide_bg_img ) {
            $bg_img = '';
        } else {
            $bg_img = !empty( $bg_img_from_page ) ? $bg_img_from_page['url'] : $bg_img;
        }

        ?>
        <!-- breadcrumb_section - start
        ================================================== -->
        <section class="page-title <?php print esc_attr( $wpbreadcrumb_class );?>" data-bg-color="<?php print esc_attr($bg_color); ?>" style="background-image: url(<?php print esc_attr($bg_img);?>)">
            <div class="auto-container">
                <h2><?php echo wp_kses_post( $title ); ?></h2>
                <?php nextbit_breadcrumb_callback();?>
            </div>
        </section>
        <!-- breadcrumb_section - end
        ================================================== -->
        <?php
}
}
add_action( 'nextbit_before_main_content', 'nextbit_breadcrumb' );

function nextbit_breadcrumb_callback() {
    $args = [
        'show_browse'   => false,
        'post_taxonomy' => ['product' => 'product_cat'],
    ];
    $breadcrumb = new WpBreadcrumb_Class( $args );

    return $breadcrumb->trail();
}

// nextbit_search_form
function nextbit_search_form() {
    ?>
    <div class="search-popup">
        <div class="color-layer"></div>
        <button class="close-search"><span class="fa fa-arrow-up"></span></button>
        <form method="post" action="<?php print esc_url( home_url( '/' ) );?>">
            <div class="form-group">
                <input type="search" name="s" value="<?php print esc_attr( get_search_query() )?>" placeholder="<?php print esc_attr__( 'Search Here', 'nextbit' );?>" >
                <button type="submit" class="search-btn"><i class="far fa-search"></i></button>
            </div>
        </form>
    </div>

    <?php
}

add_action( 'nextbit_before_main_content', 'nextbit_search_form' );

// nextbit_search_form
function nextbit_header_search_form() {
    ?>
        <form role="search" method="get" action="<?php print esc_url( home_url( '/' ) );?>">
            <input type="search" name="s" value="<?php print esc_attr( get_search_query() )?>" placeholder="<?php print esc_attr( 'Search Keywords', 'frudbaz' );?>">
            <button type="submit"><i class="far fa-search"></i></button>
        </form>

    <?php
}

/**
 *
 * pagination
 */
if ( !function_exists( 'nextbit_pagination' ) ) {

    function nextbit_pagi_callback( $pagination ) {
        return $pagination;
    }

    //page navegation
    function nextbit_pagination( $prev, $next, $pages, $args ) {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ( $pages == '' ) {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if ( !$pages ) {
                $pages = 1;
            }

        }

        $pagination = [
            'base'      => add_query_arg( 'paged', '%#%' ),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ( $wp_rewrite->using_permalinks() ) {
            $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
        }

        if ( !empty( $wp_query->query_vars['s'] ) ) {
            $pagination['add_args'] = ['s' => get_query_var( 's' )];
        }

        $pagi = '';
        if ( paginate_links( $pagination ) != '' ) {
            $paginations = paginate_links( $pagination );
            $pagi .= '<ul class="pagination_nav ul_li">';
            foreach ( $paginations as $key => $pg ) {
                $pagi .= '<li>' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print nextbit_pagi_callback( $pagi );
    }
}

// rtl_enable
function rtl_enable() {
    $my_current_lang = apply_filters( 'wpml_current_language', NULL );
    $rtl_enable = get_theme_mod( 'rtl_switch', false );
    if ( $my_current_lang != 'en' && $rtl_enable ) {
        return true;
    } else {
        return false;
    }
}

// header top bg color
function nextbit_breadcrumb_bg_color() {
    $color_code = get_theme_mod( 'nextbit_breadcrumb_bg_color', '#222' );
    wp_enqueue_style( 'nextbit-custom', NEXTBIT_THEME_CSS_DIR . 'nextbit-custom.css', [] );
    if ( $color_code != '' ) {
        $custom_css = '';
        $custom_css .= ".breadcrumb-bg.gray-bg{ background: " . $color_code . "}";

        wp_add_inline_style( 'nextbit-breadcrumb-bg', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'nextbit_breadcrumb_bg_color' );

// breadcrumb-spacing top
function nextbit_breadcrumb_spacing() {
    $padding_px = get_theme_mod( 'nextbit_breadcrumb_spacing', '160px' );
    wp_enqueue_style( 'nextbit-custom', NEXTBIT_THEME_CSS_DIR . 'nextbit-custom.css', [] );
    if ( $padding_px != '' ) {
        $custom_css = '';
        $custom_css .= ".breadcrumb-spacing{ padding-top: " . $padding_px . "}";

        wp_add_inline_style( 'nextbit-breadcrumb-top-spacing', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'nextbit_breadcrumb_spacing' );

// breadcrumb-spacing bottom
function nextbit_breadcrumb_bottom_spacing() {
    $padding_px = get_theme_mod( 'nextbit_breadcrumb_bottom_spacing', '160px' );
    wp_enqueue_style( 'nextbit-custom', NEXTBIT_THEME_CSS_DIR . 'nextbit-custom.css', [] );
    if ( $padding_px != '' ) {
        $custom_css = '';
        $custom_css .= ".breadcrumb-spacing{ padding-bottom: " . $padding_px . "}";

        wp_add_inline_style( 'nextbit-breadcrumb-bottom-spacing', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'nextbit_breadcrumb_bottom_spacing' );

// scrollup
function nextbit_scrollup_switch() {
    $scrollup_switch = get_theme_mod( 'nextbit_scrollup_switch', false );
    wp_enqueue_style( 'nextbit-custom', NEXTBIT_THEME_CSS_DIR . 'nextbit-custom.css', [] );
    if ( $scrollup_switch ) {
        $custom_css = '';
        $custom_css .= "#scrollUp{ display: none !important;}";

        wp_add_inline_style( 'nextbit-scrollup-switch', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'nextbit_scrollup_switch' );

// theme color
function nextbit_custom_color() {
    $color_code = get_theme_mod( 'nextbit_color_option', '#ff5e14' );
    wp_enqueue_style( 'nextbit-custom', NEXTBIT_THEME_CSS_DIR . 'nextbit-custom.css', [] );
    if ( $color_code != '' ) {
        $custom_css = '';
        $custom_css .= ".ggg { background: " . $color_code . "}";

        $custom_css .= ".hhh { color: " . $color_code . "}";

        $custom_css .= ".ghgh { border-color: " . $color_code . "}";
        wp_add_inline_style( 'nextbit-custom', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'nextbit_custom_color' );

// theme color
function nextbit_header_bg_color() {
    $color_code = get_theme_mod( 'nextbit_header_bg_color', '#00235A' );
    wp_enqueue_style( 'nextbit-custom', NEXTBIT_THEME_CSS_DIR . 'nextbit-custom.css', [] );
    if ( $color_code != '' ) {
        $custom_css = '';
        $custom_css .= "header .dark-bg { background: " . $color_code . "}";

        $custom_css .= ".ddf{ color: " . $color_code . "}";

        $custom_css .= ".dsd { border-color: " . $color_code . "}";
        wp_add_inline_style( 'nextbit-custom', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'nextbit_header_bg_color' );

// nextbit_kses_intermediate

function nextbit_get_allowed_html_tags( $level = 'basic' ) {
    $allowed_html = [
        'img'    => [
            'src'   => [],
            'class' => [],
        ],
        'b'      => [],
        'i'      => [],
        'u'      => [],
        'em'     => [],
        'br'     => [],
        'abbr'   => [
            'title' => [],
        ],
        'span'   => [
            'class' => [],
        ],
        'strong' => [],
        'p'      => [
            'class'          => [],
            'data-wow-delay' => [],
        ],
    ];

    if ( $level === 'intermediate' ) {
        $allowed_html['a'] = [
            'href'  => [],
            'title' => [],
            'class' => [],
            'id'    => [],
        ];
        $allowed_html['div'] = [
            'class' => [],
            'id'    => [],
        ];
        $allowed_html['img'] = [
            'src'   => [],
            'class' => [],
            'alt'   => [],
        ];
        $allowed_html['li'] = [
            'src'   => [],
            'class' => [],
            'alt'   => [],
        ];
        $allowed_html['i'] = [
            'src'   => [],
            'class' => [],
            'alt'   => [],
        ];
    }

    return $allowed_html;
}

function nextbit_kses_basic( $string = '' ) {
    return wp_kses( $string, nextbit_get_allowed_html_tags( 'basic' ) );
}

function nextbit_shopping_cart() {
    ob_start();
    ?>
    <div class="mini-cart-content dropdown-menu pull-right cart-panel" aria-labelledby="dropdownMenu1">
        <div class="header-mini-cart"></div>
    </div>
    <?php return ob_get_clean();
}

function nextbit_shopping_cart_two() {
    ob_start();
    ?>
    <div class="mini-cart-content dropdown-menu pull-right cart-panel" aria-labelledby="dropdownMenu2">
        <div class="header-mini-cart"></div>
    </div>
    <?php return ob_get_clean();
}