<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package nextbit
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function nextbit_body_classes( $classes ) {
    // Adds a class of hfeed to non-singular pages.
    if ( !is_singular() ) {
        $classes[] = 'hfeed';
    }
    // Adds a class of no-sidebar when there is no sidebar present.
    if ( !is_active_sidebar( 'sidebar-1' ) ) {
        $classes[] = 'no-sidebar';
    }
    return $classes;
}
add_filter( 'body_class', 'nextbit_body_classes' );

/**
 * Get tags.
 */
function nextbit_get_tag() {
    $html = '';
    if ( has_tag() ) {
        $html .= '<div class="nextbit-tags-wrapper"><div class="post-share-options"><div class="post-share-inner clearfix"><div class="pull-left tags"><span class="tags">' . esc_html__( 'Tags:', 'nextbit' ) . '</span>';
        $html .= get_the_tag_list( '', '', '' );
        $html .= '</div></div></div></div>';
    }
    return $html;
}

/**
 * Get categories.
 */
function nextbit_get_category() {

    $categories = get_the_category( get_the_ID() );
    $x = 0;
    foreach ( $categories as $category ) {

        if ( $x == 2 ) {
            break;
        }
        $x++;
        print '<li><a class="news-tag" href="' . get_category_link( $category->term_id ) . '">' . $category->cat_name . '</a></li>';

    }
}

/** img alt-text **/
function nextbit_img_alt_text( $img_er_id = null ) {
    $image_id = $img_er_id;
    $image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', false );
    $image_title = get_the_title( $image_id );

    if ( !empty( $image_id ) ) {
        if ( $image_alt ) {
            $alt_text = get_post_meta( $image_id, '_wp_attachment_image_alt', false );
        } else {
            $alt_text = get_the_title( $image_id );
        }
    } else {
        $alt_text = esc_html__( 'Image Alt Text', 'nextbit' );
    }

    return $alt_text;
}

// nextbit_ofer_sidebar_func
function nextbit_offer_sidebar_func() {
    if ( is_active_sidebar( 'offer-sidebar' ) ) {

        dynamic_sidebar( 'offer-sidebar' );
    }
}
add_action( 'nextbit_offer_sidebar', 'nextbit_offer_sidebar_func', 20 );

// nextbit_service_sidebar
function nextbit_service_sidebar_func() {
    if ( is_active_sidebar( 'services-sidebar' ) ) {

        dynamic_sidebar( 'services-sidebar' );
    }
}
add_action( 'nextbit_service_sidebar', 'nextbit_service_sidebar_func', 20 );

// nextbit_portfolio_sidebar
function nextbit_movie_sidebar_func() {
    if ( is_active_sidebar( 'movie-sidebar' ) ) {
        dynamic_sidebar( 'movie-sidebar' );
    }
}
add_action( 'nextbit_portfolio_sidebar', 'nextbit_portfolio_sidebar_func', 20 );

// nextbit_faq_sidebar
function nextbit_faq_sidebar_func() {
    if ( is_active_sidebar( 'faq-sidebar' ) ) {

        dynamic_sidebar( 'faq-sidebar' );
    }
}
add_action( 'nextbit_faq_sidebar', 'nextbit_faq_sidebar_func', 20 );