<?php
/**
 * nextbit customizer
 *
 * @package nextbit
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function nextbit_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'nextbit_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'NextBit Customizer', 'nextbit' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'header_top_setting', [
        'title'       => esc_html__( 'Header Top Options', 'nextbit' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'header_social', [
        'title'       => esc_html__( 'Header Social', 'nextbit' ),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'header_button', [
        'title'       => esc_html__( 'Header Button', 'nextbit' ),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'section_header_logo', [
        'title'       => esc_html__( 'Header Style & Logos', 'nextbit' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'nextbit' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'header_side_setting', [
        'title'       => esc_html__( 'Side Info', 'nextbit' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'nextbit' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'nextbit' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'nextbit' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'nextbit' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'nextbit' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'rtl_setting', [
        'title'       => esc_html__( 'RTL Setting', 'nextbit' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'darkmode_setting', [
        'title'       => esc_html__( 'Dark Mode Setting', 'nextbit' ),
        'description' => 'Enable Dark Mode?',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'footer_social', [
        'title'       => esc_html__( 'Footer Social', 'nextbit' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

    $wp_customize->add_section( 'footer_newslater', [
        'title'       => esc_html__( 'Footer Newslater', 'nextbit' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'nextbit_customizer',
    ] );

}

add_action( 'customize_register', 'nextbit_customizer_panels_sections' );

function _header_top_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_topbar_switch',
        'label'    => esc_html__( 'Topbar Swicher', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_header_lang',
        'label'    => esc_html__( 'Show Language', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_preloader',
        'label'    => esc_html__( 'Preloader On/Off', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_backtotop',
        'label'    => esc_html__( 'Back To Top On/Off', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'on',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_header_right',
        'label'    => esc_html__( 'Header Right On/Off', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_header_search',
        'label'    => esc_html__( 'Search On/Off', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_cart',
        'label'    => esc_html__( 'Cart On/Off', 'frudbaz' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_header_cart',
        'label'    => esc_html__( 'Cart On/Off', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_header_account',
        'label'    => esc_html__( 'Account On/Off', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'on',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ]
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_header_account_url',
        'label'    => esc_html__( 'Account URL', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'nextbit_header_account',
                'operator' => '==',
                'value'    => true,
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_side_hide',
        'label'    => esc_html__( 'Side Info On/Off', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_top',
        'label'    => esc_html__( 'Footer Top', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'movie_sidebar_switch',
        'label'    => esc_html__( 'Enable Movie Sidebar?', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'service_sidebar_switch',
        'label'    => esc_html__( 'Enable Service Sidebar?', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'nextbit_phone_label',
        'label'           => esc_html__( 'Label', 'nextbit' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( 'Call: ', 'nextbit' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'nextbit_phone',
        'label'           => esc_html__( 'Phone Number', 'nextbit' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( '+876 864 764 764', 'nextbit' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'nextbit_opening_time',
        'label'           => esc_html__( 'Opening Time', 'nextbit' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( 'OPENING TIME :10AM-7PM', 'nextbit' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'nextbit_mail_id',
        'label'           => esc_html__( 'Mail ID', 'nextbit' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( 'info@webmail.com', 'nextbit' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    $fields[] = [
        'type'            => 'text',
        'settings'        => 'nextbit_address_cd',
        'label'           => esc_html__( 'Address', 'nextbit' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( 'Charleston, SC 29403, USA', 'nextbit' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'nextbit_quize_offer_text',
        'label'           => esc_html__( 'Quize offer', 'nextbit' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( 'Attend to our quize offer & win free network. <a href="#">Free Network</a>', 'nextbit' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_header_top_button',
        'label'    => esc_html__( 'Button Text', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( 'Contact Now', 'nextbit' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_header_top_button_url',
        'label'    => esc_html__( 'Button URL', 'nextbit' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'nextbit_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    return $fields;

}
add_filter( 'kirki/fields', '_header_top_fields' );

/*
Header Social
 */
function _header_social_fields( $fields ) {
    // header section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_topbar_fb_url',
        'label'    => esc_html__( 'Facebook Url', 'nextbit' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_topbar_twitter_url',
        'label'    => esc_html__( 'Twitter Url', 'nextbit' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_topbar_google_url',
        'label'    => esc_html__( 'Google Url', 'nextbit' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_topbar_linkedin_url',
        'label'    => esc_html__( 'Linkedin Url', 'nextbit' ),
        'section'  => 'header_social',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_topbar_instagram_url',
        'label'    => esc_html__( 'Instagram Url', 'nextbit' ),
        'section'  => 'header_social',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_topbar_youtube_url',
        'label'    => esc_html__( 'Youtube Url', 'nextbit' ),
        'section'  => 'header_social',
        'priority' => 10,
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_header_social_fields' );

/*
Header Button
 */
function _header_button_fields( $fields ) {
    // header section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_header_button',
        'label'    => esc_html__( 'Button Text', 'nextbit' ),
        'section'  => 'header_button',
        'default'  => esc_html__( 'See Our Package', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_header_button_url',
        'label'    => esc_html__( 'Button URL', 'nextbit' ),
        'section'  => 'header_button',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_header_button_fields' );

/*
Header Settings
 */
function _header_header_fields( $fields ) {

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Choose Header Style', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => 'header-style-1',
        'placeholder' => esc_html__( 'Select an option...', 'nextbit' ),
        'priority'    => 10,
        'choices'     => [
            'header-style-1' => esc_html__( 'Header Style 1', 'nextbit' ),
            'header-style-2' => esc_html__( 'Header Style 2', 'nextbit' ),
            'header-style-3' => esc_html__( 'Header Style 3', 'nextbit' ),
            'header-style-4' => esc_html__( 'Header Style 4', 'nextbit' ),
            'header-style-5' => esc_html__( 'Header Style 5', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header Logo', 'nextbit' ),
        'description' => esc_html__( 'Upload Your Logo.', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo.svg',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'seconday_logo',
        'label'       => esc_html__( 'Header Logo', 'nextbit' ),
        'description' => esc_html__( 'Header White Logo', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-2.svg',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'third_logo',
        'label'       => esc_html__( 'Header Third Logo', 'nextbit' ),
        'description' => esc_html__( 'Header White Logo', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-3.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'forth_logo',
        'label'       => esc_html__( 'Header Forth Logo', 'nextbit' ),
        'description' => esc_html__( 'Home 5 Logo', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-7.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'forth_blue_logo',
        'label'       => esc_html__( 'Header Five Blue Logo', 'nextbit' ),
        'description' => esc_html__( 'Home 5 Blue Logo', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-8.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'forth_six_logo',
        'label'       => esc_html__( 'Header Six Logo', 'nextbit' ),
        'description' => esc_html__( 'Home 6 Blue Logo', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-4.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'seven_logo',
        'label'       => esc_html__( 'Header Seven Logo', 'nextbit' ),
        'description' => esc_html__( 'Home 7 Logo', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-9.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'eight_logo',
        'label'       => esc_html__( 'Header Eight Logo', 'nextbit' ),
        'description' => esc_html__( 'Home 8 Logo', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-10.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'eight_logo_dark',
        'label'       => esc_html__( 'Header Eight Logo Dark', 'nextbit' ),
        'description' => esc_html__( 'Home Eight Logo Dark', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/logo-10-dark.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'favicon_url',
        'label'       => esc_html__( 'Favicon', 'nextbit' ),
        'description' => esc_html__( 'Favicon Icon', 'nextbit' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/images/favicon.ico',
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );

/*
Header Side Info
 */
function _header_side_fields( $fields ) {
    // side info settings

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_side_logo',
        'label'       => esc_html__( 'Logo Side', 'nextbit' ),
        'description' => esc_html__( 'Logo Side', 'nextbit' ),
        'section'     => 'header_side_setting',
        'default'     => get_template_directory_uri() . '/assets/images/logo-2.svg',
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_extra_about_title',
        'label'    => esc_html__( 'About Title', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'About Us', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'nextbit_extra_about_text',
        'label'    => esc_html__( 'About Description', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'About Us Desc...', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_extra_button',
        'label'    => esc_html__( 'Button Text', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'Consultation', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_extra_button_url',
        'label'    => esc_html__( 'Button URL', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];
    // contact
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_contact_title',
        'label'    => esc_html__( 'Contact Title', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'Contact Us', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_extra_address',
        'label'    => esc_html__( 'Office Address', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'Chicago 12, Melborne City, USA', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_extra_phone',
        'label'    => esc_html__( 'Phone Number', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '+1255-568-6523', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_extra_email',
        'label'    => esc_html__( 'Email ID', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'information@gmail.com', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_extra_hour',
        'label'    => esc_html__( 'Open Hour', 'nextbit' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'Week Days: 09.00 to 18.00 Sunday: Closed', 'nextbit' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_side_fields' );

/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {
    // Breadcrumb Setting
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_bg_img',
        'label'       => esc_html__( 'Breadcrumb Background Image', 'nextbit' ),
        'description' => esc_html__( 'Breadcrumb Background Image', 'nextbit' ),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/images/background/10.jpg',
    ];
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'nextbit_breadcrumb_bg_color',
        'label'       => __( 'Breadcrumb BG Color', 'nextbit' ),
        'description' => esc_html__( 'This is a Breadcrumb bg color control.', 'nextbit' ),
        'section'     => 'breadcrumb_setting',
        'default'     => '#f4f9fc',
        'priority'    => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_breadcrumb_top_spacing',
        'label'    => esc_html__( 'Breadcrumb Padding Top', 'nextbit' ),
        'section'  => 'breadcrumb_setting',
        'default'  => esc_html__( '160px', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_breadcrumb_bottom_spacing',
        'label'    => esc_html__( 'Breadcrumb Padding Bottom', 'nextbit' ),
        'section'  => 'breadcrumb_setting',
        'default'  => esc_html__( '160px', 'nextbit' ),
        'priority' => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_blog_btn_switch',
        'label'    => esc_html__( 'Blog BTN On/Off', 'nextbit' ),
        'section'  => 'blog_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'nextbit' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_blog_btn_rtl',
        'label'    => esc_html__( 'Blog Button text rtl', 'nextbit' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'nextbit' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'nextbit' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'nextbit' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => 'footer-style-1',
        'placeholder' => esc_html__( 'Select an option...', 'nextbit' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1' => esc_html__( 'Footer Style 1', 'nextbit' ),
            'footer-style-2' => esc_html__( 'Footer Style 2', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => '3',
        'placeholder' => esc_html__( 'Select an option...', 'nextbit' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            '5' => esc_html__( 'Widget Number 5', 'nextbit' ),
            '4' => esc_html__( 'Widget Number 4', 'nextbit' ),
            '3' => esc_html__( 'Widget Number 3', 'nextbit' ),
            '2' => esc_html__( 'Widget Number 2', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_bg',
        'label'       => esc_html__( 'Footer Background Image.', 'nextbit' ),
        'description' => esc_html__( 'Footer Background Image.', 'nextbit' ),
        'section'     => 'footer_setting',
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'nextbit_footer_bg_color',
        'label'       => __( 'Footer BG Color', 'nextbit' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => '#fff',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_logo',
        'label'       => esc_html__( 'Footer Logo.', 'nextbit' ),
        'description' => esc_html__( 'Footer Logo.', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/logo-2.svg',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_logo_two',
        'label'       => esc_html__( 'Footer Logo. Two', 'nextbit' ),
        'description' => esc_html__( 'Footer Logo. Two', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/footer-logo2.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_logo_3',
        'label'       => esc_html__( 'Footer Logo. Three', 'nextbit' ),
        'description' => esc_html__( 'Footer Logo. Three', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/footer-logo-4.png',
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_logo_4',
        'label'       => esc_html__( 'Footer Logo. Four', 'nextbit' ),
        'description' => esc_html__( 'Footer Logo. Four', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/footer-logo-5.png',
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_top_switch',
        'label'    => esc_html__( 'Footer Top On/Off', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_copyright_switch',
        'label'    => esc_html__( 'Footer Copyright On/Off', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => 'on',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_copyright',
        'label'    => esc_html__( 'Copyright text', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '&copy; 2022 Your Company. All Rights Reserved. Designed By Themexriver', 'nextbit' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_copyright_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'nextbit_mega_label',
        'section'  => 'mega_menu',
        'default'  => __( 'Footer Infos', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_info_number_icon',
        'label'       => esc_html__( 'Phone Icon', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/icons/icon-1.png',
    ];


    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_info_number_1',
        'label'    => esc_html__( 'Number 1', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '+3453-909-6565', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_info_number_2',
        'label'    => esc_html__( 'Number 2', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '+2390-875-223', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_info_mail_icon',
        'label'       => esc_html__( 'Phone Icon', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/icons/icon-2.png',
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_info_mail_1',
        'label'    => esc_html__( 'Email 1', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'infoname@gmail.com', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_info_mail_2',
        'label'    => esc_html__( 'Email 2', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'infoname@gmail.com', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'nextbit_footer_info_address_icon',
        'label'       => esc_html__( 'Phone Icon', 'nextbit' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/icons/icon-3.png',
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_info_address',
        'label'    => esc_html__( 'Address', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '503 Old Buffalo Street Northwest #205, New York-3087', 'nextbit' ),
        'priority' => 10,
    ];
    
    $fields[] = [
        'type'     => 'text',
        'settings' => 'footer_about_title',
        'label'    => esc_html__( 'Footer About Title', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'About Nextbit', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'footer4_descriotion',
        'label'    => esc_html__( 'Footer Description', 'nextbit' ),
        'section'  => 'footer_setting',
        'priority' => 10,
    ];
    
    $fields[] = [
        'type'     => 'image',
        'settings' => 'footer_24_hour_icon',
        'label'    => esc_html__( '24 Hour Icon', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/images/icons/24-hours-iocn.png',
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'footer_24_hour_title',
        'label'    => esc_html__( '24 Hour Title', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Opening HOurs', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'footer_24_hour_text_1',
        'label'    => esc_html__( 'Open Hour Text One', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Mon - Sat (8:00 - 6:00)', 'nextbit' ),
        'priority' => 10,
    ];
    
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'footer_24_hour_text_2',
        'label'    => esc_html__( 'Open Hour Text Two', 'nextbit' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Sunday - Closed', 'nextbit' ),
        'priority' => 10,
    ];
    
    $fields[] = [
        'type'     => 'text',
        'settings' => 'footer_newl_code',
        'label'    => esc_html__( 'Footer Newslater Shortcode', 'nextbit' ),
        'section'  => 'footer_setting',
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'footer_nav_title',
        'label'    => esc_html__( 'Footer Nav Title', 'nextbit' ),
        'section'  => 'footer_setting',
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'footer_newslater_title',
        'label'    => esc_html__( 'Footer Newsleter Title', 'nextbit' ),
        'section'  => 'footer_setting',
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'foo_info_title',
        'label'    => esc_html__( 'Footer Contact Info Title', 'nextbit' ),
        'section'  => 'footer_setting',
        'priority' => 10,
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

function _footer_social_fields( $fields ) {
    // header section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_fb_url',
        'label'    => esc_html__( 'Facebook Url', 'nextbit' ),
        'section'  => 'footer_social',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_twitter_url',
        'label'    => esc_html__( 'Twitter Url', 'nextbit' ),
        'section'  => 'footer_social',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_google_url',
        'label'    => esc_html__( 'Google Url', 'nextbit' ),
        'section'  => 'footer_social',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_linkedin_url',
        'label'    => esc_html__( 'Linkedin Url', 'nextbit' ),
        'section'  => 'footer_social',
        'default'  => esc_html__( '#', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_instagram_url',
        'label'    => esc_html__( 'Instagram Url', 'nextbit' ),
        'section'  => 'footer_social',
        'default'  => esc_html__( '', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_footer_youtube_url',
        'label'    => esc_html__( 'Youtube Url', 'nextbit' ),
        'section'  => 'footer_social',
        'default'  => esc_html__( '', 'nextbit' ),
        'priority' => 10,
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_footer_social_fields' );

function _footer_newslater_fields( $fields ) {
    // Footer Newslater
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'nextbit_newslater_switch',
        'label'    => esc_html__( 'Footer Newslater On/Off', 'nextbit' ),
        'section'  => 'footer_newslater',
        'default'  => 'off',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'nextbit' ),
            'off' => esc_html__( 'Disable', 'nextbit' ),
        ],
    ];

    $fields[] = [
        'type'     => 'image',
        'settings' => 'nextbit_newslater_img',
        'label'    => esc_html__( 'Bg Image', 'nextbit' ),
        'section'  => 'footer_newslater',
        'default'     => get_template_directory_uri() . '/assets/images/background/pattern-11.png',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_newslater_title',
        'label'    => esc_html__( 'Title', 'nextbit' ),
        'section'  => 'footer_newslater',
        'default'  => esc_html__( 'Sign up for our newsletter', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_newslater_description',
        'label'    => esc_html__( 'Description', 'nextbit' ),
        'section'  => 'footer_newslater',
        'default'  => esc_html__( 'Stay up to update with our latest news and products.', 'nextbit' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_newslater_shortcode',
        'label'    => esc_html__( 'Newslater Shortcode', 'nextbit' ),
        'section'  => 'footer_newslater',
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_newslater_shortcode_big',
        'label'    => esc_html__( 'Newslater Shortcode', 'nextbit' ),
        'description' => esc_html__( '(Footer Style 8)', 'nextbit' ),
        'section'  => 'footer_newslater',
        'priority' => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_footer_newslater_fields' );

// 404
function nextbit_404_fields( $fields ) {
    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_error_404_text',
        'label'    => esc_html__( '400 Text', 'nextbit' ),
        'section'  => '404_page',
        'default'  => esc_html__( '404', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_error_title',
        'label'    => esc_html__( 'Not Found Title', 'nextbit' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Sorry! we can\'t find that page!', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'nextbit_error_desc',
        'label'    => esc_html__( '404 Description Text', 'nextbit' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Oops! The page you are looking for does not exist. It might have been moved or deleted', 'nextbit' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'nextbit_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'nextbit' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'nextbit' ),
        'priority' => 10,
    ];
    return $fields;

}
add_filter( 'kirki/fields', 'nextbit_404_fields' );


/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function nextbit_theme_option( $name ) {
    $value = '';
    if ( class_exists( 'nextbit' ) ) {
        $value = Kirki::get_option( nextbit_get_theme(), $name );
    }

    return apply_filters( 'nextbit_theme_option', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function nextbit_get_theme() {
    return 'nextbit';
}