<?php 
/**
 * header style 8
 */
function nextbit_header_style_8() {

    $nextbit_header_button = get_theme_mod( 'nextbit_header_button', __( 'Cheak availibilty', 'nextbit' ) );
    $nextbit_header_button_url = get_theme_mod( 'nextbit_header_button_url', __( '#', 'nextbit' ) );


    if ( rtl_enable() ) {
        $btn_text = get_theme_mod( 'nextbit_button_text_rtl', __( 'Get A Quote', 'nextbit' ) );
    } else {
        $btn_text = get_theme_mod( 'nextbit_button_text', __( 'Get A Quote', 'nextbit' ) );
    }

    $btn_link = get_theme_mod( 'nextbit_button_link', __( '#', 'nextbit' ) );
    $id = get_the_ID();
    $nextbit_dark_mode = function_exists('get_field') ? get_field('nextbit_dark_mode', $id) : '';
    $dark_enable = get_theme_mod( 'dark_enable', true );
    $dark = (true == $nextbit_dark_mode ) ? $nextbit_dark_mode : $dark_enable;
    ?>


    <!-- header start -->
    <header id="sticky-header" class="header__area header__transparent header__style-2 header-style-8">
        <div class="container">
            <div class="header__main-wrap d-flex align-items-center">
                <div class="header__logo">
                    <?php nextbit_header_logo_5(); ?>
                </div>
                <div class="main_menu_wrap navbar navbar-expand-lg">
                    <nav class="main_menu collapse navbar-collapse">
                        <?php nextbit_header_menu_7();?>
                    </nav>
                </div>
                <div class="header__btn ul_li_right">
                    <?php if(!empty( $nextbit_header_button)): ?>
                    <a class="thm-btn thm-btn--radius" href="<?php echo esc_url($nextbit_header_button_url); ?>">
                        <span class="btn-wrap">
                            <span><?php echo esc_html($nextbit_header_button); ?></span>
                            <span><?php echo esc_html($nextbit_header_button); ?></span>
                        </span>
                        <i class="far fa-arrow-right"></i>
                    </a>
                    <?php endif; ?>
                    
                    <div class="header__icons ul_li">
                        <div class="hamburger_menu">
                            <a href="javascript:void(0);" class="active">
                                <div class="icon bar d-lg-none">
                                    <span><i class="far fa-bars"></i></span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- header end -->

    <!-- slide-bar start -->
    <aside class="slide-bar">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="fal fa-times"></i></a>
        </div>


        <!-- side-mobile-menu start -->
        <nav class="side-mobile-menu">
            <div class="header-mobile-search">
                <?php nextbit_header_search_form(); ?>
            </div>
            <?php nextbit_mobile_menu();?>
        </nav>
        <!-- side-mobile-menu end -->
    </aside>
    <div class="body-overlay"></div>
    <!-- slide-bar end -->
    
<?php
}