<?php 
/**
 * header style 7
 */
function nextbit_header_style_7() {

    $nextbit_button_text = get_theme_mod( 'nextbit_button_text', __( 'GET APPOINTMENT', 'nextbit' ) );
    $nextbit_button_link = get_theme_mod( 'nextbit_button_link', __( '#', 'nextbit' ) );

    $nextbit_topbar_switch = get_theme_mod( 'nextbit_topbar_switch', false );
    $nextbit_phone_label = get_theme_mod( 'nextbit_phone_label', __( 'Call: ', 'nextbit' ) );
    $nextbit_phone = get_theme_mod( 'nextbit_phone', __( '+876 864 764 764', 'nextbit' ) );
    $nextbit_opening_time = get_theme_mod( 'nextbit_opening_time', __( 'OPENING TIME :10AM-7PM', 'nextbit' ) );
    $nextbit_address_cd = get_theme_mod( 'nextbit_address_cd', __( 'Attend to our quize offer & win free network. Free Network', 'nextbit' ) );
    $nextbit_mail_id = get_theme_mod( 'nextbit_mail_id', __( 'info@webmail.com', 'nextbit' ) );
    $nextbit_header_right = get_theme_mod( 'nextbit_header_right', false );
    $nextbit_header_search = get_theme_mod( 'nextbit_header_search', false );
    $nextbit_header_cart = get_theme_mod( 'nextbit_header_cart', false );
    $nextbit_header_account = get_theme_mod( 'nextbit_header_account', true );
    $nextbit_header_account_url = get_theme_mod( 'nextbit_header_account_url', __( '#', 'nextbit' ) );
    $nextbit_side = get_theme_mod( 'nextbit_side_hide', false );
    $nextbit_header_top_button = get_theme_mod( 'nextbit_header_top_button', __( 'Contact Now', 'nextbit' ) );
    $nextbit_header_top_button_url = get_theme_mod( 'nextbit_header_top_button_url', __( '#', 'nextbit' ) );
    $nextbit_quize_offer_text = get_theme_mod( 'nextbit_quize_offer_text', __( 'Attend to our quize offer & win free network. <a href="#">Free Network</a>', 'nextbit' ) );

    $nextbit_header_button = get_theme_mod( 'nextbit_header_button', __( 'See Our Package', 'nextbit' ) );
    $nextbit_header_button_url = get_theme_mod( 'nextbit_header_button_url', __( '#', 'nextbit' ) );

    $nextbit_cart = get_theme_mod( 'nextbit_cart', false );

    if ( rtl_enable() ) {
        $btn_text = get_theme_mod( 'nextbit_button_text_rtl', __( 'Get A Quote', 'nextbit' ) );
    } else {
        $btn_text = get_theme_mod( 'nextbit_button_text', __( 'Get A Quote', 'nextbit' ) );
    }

    $btn_link = get_theme_mod( 'nextbit_button_link', __( '#', 'nextbit' ) );
    $id = get_the_ID();
    $nextbit_dark_mode = function_exists('get_field') ? get_field('nextbit_dark_mode', $id) : '';
    $dark_enable = get_theme_mod( 'dark_enable', true );
    $dark = (true == $nextbit_dark_mode ) ? $nextbit_dark_mode : $dark_enable;
    ?>



    <!-- header start -->
    <header class="header__area header-style-7">
        <?php if( $nextbit_topbar_switch == true ) : ?>
        <div class="header__top">
            <div class="container">
                <div class="row">
                    <div class="col-xl-5 col-lg-5">
                        <?php if(!empty( $nextbit_quize_offer_text)): ?>
                        <div class="header__top-text">
                            <p><i class="fas fa-comments"></i><?php echo ($nextbit_quize_offer_text); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-xl-7 col-lg-7">
                        <div class="header__top-right ul_li_right">
                            <?php if(!empty( $nextbit_address_cd )) : ?>
                            <div class="header__top-text">
                                <p><i class="far fa-map-marker-alt"></i><?php echo esc_html($nextbit_address_cd); ?></p>
                            </div>
                            <?php endif; ?>
                            
                            <?php nextbit_header_social_profiles_2(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header__info">
            <div class="container">
                <div class="header__info-wrap">
                    <div class="header__logo">
                        <?php nextbit_header_logo_4(); ?>
                    </div>
                    <ul class="header__contact-info ul_li_center">

                        <?php if(!empty( $nextbit_phone )) : ?>
                        <li><i class="far fa-phone-plus"></i><a href="tel:<?php echo esc_attr($nextbit_phone); ?>"><?php echo esc_html($nextbit_phone); ?></a></li>
                        <?php endif; ?>

                        <?php if(!empty($nextbit_opening_time)): ?>
                        <li><i class="far fa-alarm-clock"></i><?php echo esc_html( $nextbit_opening_time ); ?></li>
                        <?php endif; ?>

                        <?php if(!empty( $nextbit_mail_id )) : ?>
                        <li><i class="far fa-envelope"></i><a href="mailto:<?php echo esc_attr($nextbit_mail_id); ?>"><?php echo esc_html($nextbit_mail_id); ?></a></li>
                        <?php endif; ?>
                        
                    </ul>
                    <?php if(!empty( $nextbit_header_top_button)): ?>
                    <div class="header__btn text-md-right">
                        <a class="thm-btn thm-btn--radius" href="<?php echo esc_url($nextbit_header_top_button_url); ?>">
                            <span class="btn-wrap">
                                <span><?php echo esc_html($nextbit_header_top_button); ?></span>
                                <span><?php echo esc_html($nextbit_header_top_button); ?></span>
                            </span>
                            <i class="far fa-arrow-right"></i>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div id="sticky-header" class="header__main margin-lr-45">
            <div class="container">
                <div class="header__main-wrap d-flex align-items-center">
                    <div class="header__btn-logo">
                        <?php if(!empty( $nextbit_header_button)): ?>
                        <div class="header__btn d-none d-lg-block">
                            <a class="thm-btn thm-btn--transparent" href="<?php echo esc_url($nextbit_header_button_url); ?>">
                                <span class="btn-wrap">
                                    <span><?php echo esc_html($nextbit_header_button); ?></span>
                                    <span><?php echo esc_html($nextbit_header_button); ?></span>
                                </span>
                                <i class="far fa-arrow-right"></i>
                            </a>
                        </div>
                        <?php endif; ?>
                        
                        <div class="header__logo d-lg-none">
                            <?php nextbit_header_logo_4(); ?>
                        </div>
                    </div>
                    
                    <div class="main_menu_wrap navbar navbar-expand-lg">
                        <nav class="main_menu collapse navbar-collapse">
                            <?php nextbit_header_menu_7();?>
                        </nav>
                        
                    </div>
                    <?php if( $nextbit_header_right == true ) : ?>
                    <div class="header_right ul_li_right">
                        <div class="header__icons ul_li">

                            <?php if( $nextbit_header_account == true ) : ?>
                            <a class="icon d-none d-lg-block" href="<?php echo esc_html($nextbit_header_account_url); ?>">
                                <i class="far fa-user"></i>
                            </a>
                            <?php endif; ?>
                            
                            <?php if( NEXTBIT_WOOCOMMERCE_ACTIVED && $nextbit_header_cart == true ) : ?>
							<!-- Cart Box -->
                            <div class="cart-box">
								<div class="dropdown">
									<button class="cart-box-btn dropdown-toggle icon" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="far fa-shopping-basket"></span>
                                    <span class="total-cart" id="nextbit-cart-count"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span></button>
                                    <?php print nextbit_shopping_cart_two(); ?>
								</div>

							</div>
							
							<!-- End Cart Box -->
                            <?php endif; ?>

                            <div class="hamburger_menu">
                                <a href="javascript:void(0);" class="active">
                                    
                                    <div class="icon bar d-lg-none">
                                        <span><i class="far fa-bars"></i></span>
                                    </div>
                                </a>
                            </div>
                            <?php if( $nextbit_header_search == true ) : ?>
                            <div class="search-box-outer icon">
                                <div class="search-box-btn"><span class="far fa-search"></span></div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </header>
    <!-- header end -->

    <!-- slide-bar start -->
    <aside class="slide-bar">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="fal fa-times"></i></a>
        </div>


        <!-- side-mobile-menu start -->
        <nav class="side-mobile-menu">
            <div class="header-mobile-search">
                <?php nextbit_header_search_form(); ?>
            </div>
            <?php nextbit_mobile_menu();?>
            
        </nav>
        <!-- side-mobile-menu end -->
    </aside>
    <div class="body-overlay"></div>
    <!-- slide-bar end -->
    
<?php
}