<?php 
/**
 * header style 1 + default
 */
function nextbit_header_style_1() {

    $nextbit_button_text = get_theme_mod( 'nextbit_button_text', __( 'GET APPOINTMENT', 'nextbit' ) );
    $nextbit_button_link = get_theme_mod( 'nextbit_button_link', __( '#', 'nextbit' ) );

    $nextbit_topbar_switch = get_theme_mod( 'nextbit_topbar_switch', false );
    $nextbit_phone_label = get_theme_mod( 'nextbit_phone_label', __( 'Call: ', 'nextbit' ) );
    $nextbit_phone = get_theme_mod( 'nextbit_phone', __( '+876 864 764 764', 'nextbit' ) );
    $nextbit_mail_id = get_theme_mod( 'nextbit_mail_id', __( 'info@webmail.com', 'nextbit' ) );
    $nextbit_header_right = get_theme_mod( 'nextbit_header_right', false );
    $nextbit_header_search = get_theme_mod( 'nextbit_header_search', false );
    $nextbit_header_cart = get_theme_mod( 'nextbit_header_cart', false );
    $nextbit_side = get_theme_mod( 'nextbit_side_hide', false );
    $nextbit_menu_col = $nextbit_header_right ? 'col-lg-7 d-none d-lg-block' : 'col-xl-10 col-lg-10 col-md-6 col-6';
    $nextbit_menu_right = !empty( $nextbit_header_right )  ? 'justify-content-center' : 'justify-content-end';
    $nextbit_side_padding = !empty( $nextbit_side )  ? 'justify-content-center' : ' position-static';

    if ( rtl_enable() ) {
        $btn_text = get_theme_mod( 'nextbit_button_text_rtl', __( 'Get A Quote', 'nextbit' ) );
    } else {
        $btn_text = get_theme_mod( 'nextbit_button_text', __( 'Get A Quote', 'nextbit' ) );
    }

    $btn_link = get_theme_mod( 'nextbit_button_link', __( '#', 'nextbit' ) );
    $id = get_the_ID();
    $nextbit_dark_mode = function_exists('get_field') ? get_field('nextbit_dark_mode', $id) : '';
    $dark_enable = get_theme_mod( 'dark_enable', true );
    $dark = (true == $nextbit_dark_mode ) ? $nextbit_dark_mode : $dark_enable;
    ?>


    <header class="main-header header-style-1">
    <?php if( $nextbit_topbar_switch == true ) : ?>
		<!-- Header Top -->
		<div class="header-top">
			<div class="auto-container clearfix">
				<div class="pull-left">
					<ul class="info">

                        <?php if(!empty( $nextbit_phone )) : ?>
						<li><a href="tel:<?php echo esc_attr($nextbit_phone); ?>"><span class="icon flaticon-maps-and-flags"></span>
                            <?php echo esc_html($nextbit_phone_label); ?>
                            <?php echo esc_html($nextbit_phone); ?>
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if(!empty( $nextbit_mail_id )) : ?>
						<li>
                            <a href="mailto:<?php echo esc_attr($nextbit_mail_id); ?>"><span class="icon flaticon-email-2"></span>
                                <?php echo esc_html($nextbit_mail_id); ?>
                            </a>
                        </li>
                        <?php endif; ?>

					</ul>
				</div>
				<div class="pull-right clearfix">
					<!-- Social Box -->
                    <?php nextbit_header_social_profiles(); ?>
				</div>

			</div>
		</div>
        <!-- Header Lower -->
        <?php endif; ?>

        <div class="header-lower header-lower-s-1 ">

			<div class="auto-container clearfix">
				<div class="inner-container clearfix">

					<div class="pull-left logo-box">
						<div class="logo">
                            <?php nextbit_header_logo(); ?>
                        </div>
					</div>
                    <?php if( $nextbit_header_right == false ) : ?>
                    <div class="pull-right">
                        <div class="nav-outer clearfix">
                            <!-- Mobile Navigation Toggler -->
                            <div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
                            <!-- Main Menu -->
                            <nav class="main-menu show navbar-expand-md">
                                <div class="navbar-header">
                                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                    </button>
                                </div>

                                <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                                    <?php nextbit_header_menu(); ?>
                                </div>

                            </nav>

                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if( $nextbit_header_right == true ) : ?>
					<div class="nav-outer clearfix">
						<!-- Mobile Navigation Toggler -->
						<div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
						<!-- Main Menu -->
						<nav class="main-menu show navbar-expand-md">
							<div class="navbar-header">
								<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
							</div>

							<div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                                <?php nextbit_header_menu(); ?>
							</div>

						</nav>
						<!-- Main Menu End-->
                        <?php if( $nextbit_header_right == true ) : ?>
						<!-- Outer Box -->
						<div class="outer-box clearfix">

                            <?php if( $nextbit_header_search == true ) : ?>
							<!--Search Box-->
							<div class="search-box-outer">
								<div class="search-box-btn"><span class="fa fa-search"></span></div>
							</div>
                            <?php endif; ?>

                            <?php if( NEXTBIT_WOOCOMMERCE_ACTIVED && $nextbit_header_cart == true ) : ?>
							<!-- Cart Box -->
							<div class="cart-box">
								<div class="dropdown">
									<button class="cart-box-btn dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="flaticon-shopping-bag-2"></span>
                                    <span class="total-cart" id="nextbit-cart-count"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span></button>
                                    <?php print nextbit_shopping_cart_two(); ?>
								</div>

							</div>
							<!-- End Cart Box -->
                            <?php endif; ?>

                            <?php if( $nextbit_side == true ) : ?>
							<!-- Nav Btn -->
							<div class="nav-btn navSidebar-button"><span class="icon flaticon-dots-menu"></span></div>
                            <?php endif; ?>

						</div>
						<!-- End Outer Box -->
                        <?php endif; ?>
					</div>
                    <?php endif; ?>

				</div>

			</div>
        </div>
        <!-- End Header Lower -->

		<!-- Sticky Header  -->
        <div class="sticky-header">
            <div class="auto-container clearfix">
                <!-- Logo -->
                <div class="logo pull-left">
                    <?php nextbit_header_logo(); ?>
                </div>

                <?php if( $nextbit_header_right == false ) : ?>
                <div class="pull-right header-right-off">
                    <div class="nav-outer clearfix">
                        <!-- Mobile Navigation Toggler -->
                        <div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
                        <!-- Main Menu -->
                        <nav class="main-menu show navbar-expand-md">
                            <div class="navbar-header">
                                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                </button>
                            </div>

                            <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                                <?php nextbit_header_menu(); ?>
                            </div>

                        </nav>

                    </div>
                </div>
                <?php endif; ?>

                <!--Right Col-->
                <div class="pull-right">
                    <!-- Main Menu -->
                    <nav class="main-menu">
                        <!--Keep This Empty / Menu will come through Javascript-->
                    </nav><!-- Main Menu End-->

                    <?php if( $nextbit_header_right == true ) : ?>
					<!-- Outer Box -->
					<div class="outer-box clearfix">

                        <?php if( $nextbit_header_search == true ) : ?>
						<!--Search Box-->
						<div class="search-box-outer">
							<div class="search-box-btn"><span class="fa fa-search"></span></div>
						</div>
                        <?php endif; ?>

                        <?php if( NEXTBIT_WOOCOMMERCE_ACTIVED && $nextbit_header_cart == true ) : ?>
						<!-- Cart Box -->
						<div class="cart-box">
							<div class="dropdown">
								<button class="cart-box-btn dropdown-toggle" type="button" id="dropdownMenu2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="flaticon-shopping-bag-2"></span>
                                <span class="total-cart" id="nextbit-cart-count-2"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span></button>
                                <?php print nextbit_shopping_cart(); ?>
							</div>
						</div>
						<!-- End Cart Box -->
                        <?php endif; ?>

                        <?php if( $nextbit_side == true ) : ?>
						<!-- Nav Btn -->
						<div class="nav-btn navSidebar-button"><span class="icon flaticon-dots-menu"></span></div>
                        <?php endif; ?>

					</div>
					<!-- End Outer Box -->
                    <?php endif; ?>

                </div>
            </div>
        </div><!-- End Sticky Menu -->

		<!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-multiply"></span></div>

            <nav class="menu-box">
                <div class="nav-logo"><?php nextbit_header_logo(); ?></div>
                <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            </nav>
        </div><!-- End Mobile Menu -->

    </header>
    <!-- slide-bar end -->
    <?php nextbit_side_info(); ?>
<?php
}