<?php

function nextbit_footer_style_6(){ 
    $footer_top_switch = get_theme_mod( 'footer_top_switch', false );

    $nextbit_footer_logo_4 = get_theme_mod( 'nextbit_footer_logo_4', get_template_directory_uri() . '/assets/images/footer-logo-5.png' );
    
    $nextbit_newslater_title = get_theme_mod( 'nextbit_newslater_title', esc_html__('Still You Need Our Support ?', 'nextbit') );
    $nextbit_newslater_description = get_theme_mod( 'nextbit_newslater_description', esc_html__('Don’t wait make a smart & logical quote here. Its pretty easy.', 'nextbit') );
    $nextbit_newslater_shortcode_big = get_theme_mod( 'nextbit_newslater_shortcode_big' ); 
    
    $footer_about_title = get_theme_mod( 'footer_about_title', __('About Nextbit', 'nextbit') ); 
    $footer_about = get_theme_mod( 'footer4_descriotion', __('orporate clients and leisure travelers has been relying on Groundlink for dependable safe, and professional chauffeured car service in major cities across World.', 'nextbit') );    
    
    $footer_24_hour_icon = get_theme_mod( 'footer_24_hour_icon', get_template_directory_uri() . '/assets/images/icons/24-hours-iocn.png' );
    $footer_24_hour_title = get_theme_mod( 'footer_24_hour_title', __('Opening Hours', 'nextbit') );
    $footer_24_hour_text_1 = get_theme_mod( 'footer_24_hour_text_1', __('Mon - Sat (8:00 - 6:00)', 'nextbit') );
    $footer_24_hour_text_2 = get_theme_mod( 'footer_24_hour_text_2', __('Sunday - Closed', 'nextbit') );
    
?>



    <!-- footer start -->
    <footer class="footer__area footer__bg" style="background-image: url(<?php echo get_template_directory_uri(  ); ?>/assets/images/background/footer_bg.jpg)">
        <div class="footer__top">
            <div class="container maxw_1440">
                <div class="footer__top-wrap pt-90 pb-40">
                    <div class="row align-items-center">
                        <div class="col-xl-7 col-lg-6">
                            <div class="footer__top-text">
                                <?php if(!empty($nextbit_newslater_title)): ?>
                                <h2><?php echo esc_html( $nextbit_newslater_title ); ?></h2>
                                <?php endif; ?>

                                <?php if(!empty($nextbit_newslater_description)): ?>
                                <p><?php echo esc_html( $nextbit_newslater_description ); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-6">
                            <?php print do_shortcode($nextbit_newslater_shortcode_big); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__main pt-55 pb-100">
            <div class="container maxw_1440">
                <div class="row mt-none-50">
                    <div class="col-lg-4 col-md-6">
                        <div class="footer__widget footer__widget-about mt-50">
                            <?php if(!empty($footer_about_title)): ?>
                            <h3><?php echo esc_html( $footer_24_hour_title ); ?></h3>
                            <?php endif; ?>

                            <?php if(!empty($footer_about)): ?>
                            <p><?php echo esc_html( $footer_about ); ?></p>
                            <?php endif; ?>
                            <div class="open-hour__wrap ul_li mt-40">
                                <div class="open-hour__icon">
                                    <?php if(!empty( $footer_24_hour_icon )) : ?>
                                        <img src="<?php echo esc_url($footer_24_hour_icon); ?>" alt="<?php echo esc_attr__('img', 'nextbit'); ?>" />
                                    <?php endif; ?>
                                </div>
                                <div class="open-hour__text">
                                    <?php if(!empty( $footer_24_hour_title )) : ?>
                                    <h4><?php echo esc_html( $footer_24_hour_title ); ?></h4>
                                    <?php endif; ?>

                                    <?php if(!empty( $footer_24_hour_text_1 )) : ?>
                                    <span><?php echo esc_html( $footer_24_hour_text_1 ); ?></span>
                                    <?php endif; ?>

                                    <?php if(!empty( $footer_24_hour_text_2 )) : ?>
                                    <span><?php echo esc_html( $footer_24_hour_text_2 ); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if(is_active_sidebar( 'footer-6' )):?>
                    <div class="col-lg-3 col-md-6">
                        <div class="footer__widget useful-links mt-50">
                            <?php dynamic_sidebar( 'footer-6' );?>
                        </div>
                    </div>
                    <?php endif;?>

                    <?php if(is_active_sidebar( 'footer-7' )):?>
                    <div class="col-lg-2 col-md-6">
                        <div class="footer__widget footer__widget-link3 mt-50">
                            <?php dynamic_sidebar( 'footer-7' );?>
                        </div>
                    </div>
                    <?php endif;?>
                    
                    <?php if(is_active_sidebar( 'footer-8' )):?>
                    <div class="col-lg-3 col-md-6">
                        <div class="footer__widget footer__widget-blog mt-50">
                            <?php dynamic_sidebar( 'footer-8' );?>
                        </div>
                    </div>
                    <?php endif;?>
                </div>
            </div>
        </div>
        <div class="footer__copyright">
            <div class="container maxw_1440">
                <div class="footer__copyright-wrap pt-25 pb-25">
                    <div class="row align-items-center mt-none-20">
                        <div class="col-xl-3 col-lg-2 col-md-3 mt-20">
                            <div class="footer__logo">
                                <a href="<?php print esc_url( home_url( '/' ) );?>"><img src="<?php echo esc_url($nextbit_footer_logo_4);?>" alt="<?php echo esc_attr__('logo', 'nextbit') ?>"></a>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-9 mt-20">
                            <div class="footer__copyright-text text-center">
                                <?php print nextbit_copyright_text(); ?>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-4 col-md-12">
                            <?php nextbit_footer_social_profiles_2(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer end -->

<?php 
}