<?php 
/**
 * footer  style_defaut
 */
function nextbit_footer_style_1() {

    $footer_bg_img = get_theme_mod( 'nextbit_footer_bg' );
    $nextbit_footer_logo = get_theme_mod( 'nextbit_footer_logo', get_template_directory_uri() . '/assets/images/logo-2.svg' );
    $nextbit_copyright_center = $nextbit_footer_logo ? 'col-lg-4 offset-lg-4 col-md-6 text-right' : 'col-lg-12 text-center';
    $nextbit_footer_bg_url_from_page = function_exists( 'get_field' ) ? get_field( 'nextbit_footer_bg' ) : '';
    $nextbit_footer_bg_color_from_page = function_exists( 'get_field' ) ? get_field( 'nextbit_footer_bg_color', '#1b2026' ) : '';
    $footer_bg_color = get_theme_mod( 'nextbit_footer_bg_color', '#fff' );
    $footer_copyright_switch = get_theme_mod( 'footer_copyright_switch', true );
    $footer_top_switch = get_theme_mod( 'footer_top_switch', false );
    $footer_top = get_theme_mod( 'footer_top', false );
    $footer_top_class = !empty( $footer_top == false )  ? 'footer-top-off' : '';

    // bg image
    $bg_img = !empty( $nextbit_footer_bg_url_from_page['url'] ) ? $nextbit_footer_bg_url_from_page['url'] : $footer_bg_img;

    // bg color
    $bg_color = !empty( $nextbit_footer_bg_color_from_page ) ? $nextbit_footer_bg_color_from_page : $footer_bg_color;

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod( 'footer_widget_number', 3 );

    for ( $num = 1; $num <= 3; $num++ ) {
        if ( is_active_sidebar( 'footer-' . $num ) ) {
            $footer_columns++;
        }
    }

    switch ( $footer_columns ) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
    case '3':
        $footer_class[1] = 'col-lg-4 col-md-4 col-sm-4';
        $footer_class[2] = 'col-lg-4 col-md-4 col-sm-4';
        $footer_class[3] = 'col-lg-4 col-md-4 col-sm-4';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-3 col-md-6';
        break;
    }

    ?>
    <!-- footer_section - start
    ================================================== -->
    <?php
        $id = get_the_ID();
        $hide_footer = function_exists('get_field') ? get_field('hide_footer', $id) : '';
        $footer_headline_from_page = function_exists( 'get_field' ) ? get_field( 'footer_headline', $id ) : '';
        if ( empty( $hide_footer ) ) :

        $nextbit_footer_logo = get_theme_mod( 'nextbit_footer_logo', get_template_directory_uri() . '/assets/images/logo-2.svg' );
        $nextbit_dark_mode = function_exists('get_field') ? get_field('nextbit_dark_mode', $id) : '';
        $dark_enable = get_theme_mod( 'dark_enable', true );
        $dark = (true == $nextbit_dark_mode ) ? $nextbit_dark_mode : $dark_enable;

        $nextbit_footer_info_number_icon = get_theme_mod( 'nextbit_footer_info_number_icon', get_template_directory_uri() . '/assets/images/icons/icon-1.png' );
        $nextbit_footer_info_mail_icon = get_theme_mod( 'nextbit_footer_info_mail_icon', get_template_directory_uri() . '/assets/images/icons/icon-2.png' );
        $nextbit_footer_info_address_icon = get_theme_mod( 'nextbit_footer_info_address_icon', get_template_directory_uri() . '/assets/images/icons/icon-3.png' );
        $nextbit_footer_info_number_1 = get_theme_mod( 'nextbit_footer_info_number_1', __('+3453-909-6565', 'nextbit') );
        $nextbit_footer_info_number_2 = get_theme_mod( 'nextbit_footer_info_number_2', __('+3453-909-6565', 'nextbit') );
        $nextbit_footer_info_mail_1 = get_theme_mod( 'nextbit_footer_info_mail_1', __('infoname@gmail.com', 'nextbit') );
        $nextbit_footer_info_mail_2 = get_theme_mod( 'nextbit_footer_info_mail_2', __('infoname@gmail.com', 'nextbit') );
        $nextbit_footer_info_address = get_theme_mod( 'nextbit_footer_info_address', __('503 Old Buffalo Street Northwest #205, New York-3087', 'nextbit') );


    ?>
    <footer class="main-footer <?php echo esc_attr($footer_top_class); ?>">

        <?php if(!empty( $footer_top_switch == true )) : ?>
		<div class="pattern-layer-one" style="background-image: url(<?php echo get_template_directory_uri(  ); ?>/assets/images/background/pattern-12.png)"></div>
		<div class="pattern-layer-two" style="background-image: url(<?php echo get_template_directory_uri(  ); ?>/assets/images/background/pattern-13.png)"></div>
        <?php endif; ?>

        <?php if ( is_active_sidebar('footer-1') OR is_active_sidebar('footer-2') OR is_active_sidebar('footer-3') OR $footer_top_switch == true ): ?>
    	<div class="auto-container">
            <div class="widgets-section">
                <?php if(!empty( $footer_top_switch == true )) : ?>
                <?php if(!empty( $nextbit_footer_logo )) : ?>
            	<div class="logo">
					<a href="<?php print esc_url( home_url( '/' ) );?>">
                        <img src="<?php print esc_url($nextbit_footer_logo); ?>" alt="<?php echo esc_attr__('logo', 'nextbit') ?>" />
                    </a>
				</div>
                <?php endif; ?>
                <?php endif; ?>
                <?php if ( is_active_sidebar('footer-1') OR is_active_sidebar('footer-2') OR is_active_sidebar('footer-3') ): ?>
                    <div class="footer-widget-wrapper">
                        <div class="row mt-none-30">
                            <?php
                                if ( $footer_columns < 3 ) {
                                    print '<div class="col-lg-4 col-md-6 col-sm-6">';
                                    dynamic_sidebar( 'footer-1');
                                    print '</div>';

                                    print '<div class="col-lg-4 col-md-6 col-sm-6">';
                                    dynamic_sidebar( 'footer-2');
                                    print '</div>';

                                    print '<div class="col-lg-4 col-md-6 col-sm-6">';
                                    dynamic_sidebar( 'footer-3');
                                    print '</div>';

                                }
                                else{
                                    for( $num=1; $num <= $footer_columns; $num++ ) {
                                        if ( !is_active_sidebar( 'footer-'. $num ) ) continue;
                                        print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                        dynamic_sidebar( 'footer-'. $num );
                                        print '</div>';
                                    }
                                }
                            ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(!empty( $footer_top_switch == true )) : ?>
				<ul class="contact-info-list">

					<li>
                        <?php if(!empty( $nextbit_footer_info_number_icon )) : ?>
						<span class="icon"><img src="<?php echo esc_url($nextbit_footer_info_number_icon); ?>" alt="<?php echo esc_attr__('img', 'nextbit'); ?>" /></span>
                        <?php endif; ?>

                        <?php if(!empty( $nextbit_footer_info_number_1 )) : ?>
						<a href="tel:<?php echo esc_attr($nextbit_footer_info_number_1); ?>"><?php echo esc_html($nextbit_footer_info_number_1); ?></a><br>
                        <?php endif; ?>

                        <?php if(!empty( $nextbit_footer_info_number_2 )) : ?>
						<a href="tel:<?php echo esc_attr($nextbit_footer_info_number_2); ?>"><?php echo esc_html($nextbit_footer_info_number_2); ?></a>
                        <?php endif; ?>
					</li>

					<li>
                        <?php if(!empty( $nextbit_footer_info_mail_icon )) : ?>
						<span class="icon"><img src="<?php echo esc_url($nextbit_footer_info_mail_icon); ?>" alt="<?php echo esc_attr__('img', 'nextbit'); ?>" /></span>
                        <?php endif; ?>

                        <?php if(!empty( $nextbit_footer_info_mail_1 )) : ?>
						<a href="mailto:<?php echo esc_html($nextbit_footer_info_mail_1); ?>"><?php echo esc_html($nextbit_footer_info_mail_1); ?></a><br>
                        <?php endif; ?>

                        <?php if(!empty( $nextbit_footer_info_mail_2 )) : ?>
						<a href="mailto:<?php echo esc_html($nextbit_footer_info_mail_2); ?>"><?php echo esc_html($nextbit_footer_info_mail_2); ?></a>
                        <?php endif; ?>
					</li>
					<li>
                        <?php if(!empty( $nextbit_footer_info_address_icon )) : ?>
						<span class="icon"><img src="<?php echo esc_url($nextbit_footer_info_address_icon); ?>" alt="<?php echo esc_attr__('img', 'nextbit'); ?>" /></span>
                        <?php endif; ?>

                        <?php if(!empty( $nextbit_footer_info_address )) : ?>
						<?php echo nextbit_kses_basic($nextbit_footer_info_address); ?>
                        <?php endif; ?>
					</li>
				</ul>

				<!-- Social Box -->
                <?php nextbit_footer_social_profiles(); ?>
                <?php endif; ?>
			</div>
		</div>
        <?php endif; ?>
		<!-- Footer Bottom -->
		<div class="footer-bottom">
			<div class="auto-container">
				<div class="copyright"><?php print nextbit_copyright_text(); ?></div>
			</div>
		</div>
	</footer>
    <?php endif; ?>
    <!-- footer_section - end
    ================================================== -->
<?php
}