<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package nextbit
 */
?>

<!doctype html>
<html <?php language_attributes();?> <?php print nextbit_enable_rtl();?>>
<head>
	<meta charset="<?php bloginfo( 'charset' );?>">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ): ?>
    <?php endif;?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head();?>
</head>

<body <?php body_class();?>>

      <div class="page-wrapper">
      <?php $nextbit_preloader = get_theme_mod( 'nextbit_preloader', true ); ?>
      <?php $nextbit_backtotop = get_theme_mod( 'nextbit_backtotop', true ); ?>

      <?php if ( !empty( $nextbit_preloader ) ): ?>
      <!-- preloader - start -->
      <div class="preloader">
		<span></span>
	</div>
      <!-- preloader - end -->
      <?php endif;?>

    <?php if ( !empty( $nextbit_backtotop ) ): ?>
      <!-- backtotop - start -->
      <div class="progress-wrap active-progress">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919px, 307.919px; stroke-dashoffset: 228.265px;"></path>
        </svg>
    </div>
      <!-- backtotop - end -->
   <?php endif;?>

    <?php wp_body_open();?>

    <!-- header start -->
    <?php do_action( 'nextbit_header_style' );?>
    <!-- header end -->

    <!-- wrapper-box start -->
    <?php do_action( 'nextbit_before_main_content' );?>
