<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package nextbit
 */

get_header();

$blog_column = is_active_sidebar( 'blog-sidebar' ) ? 'content-side col-lg-8 col-md-12 col-sm-12' : 'content-side col-lg-12 col-md-12 col-sm-12';

?>

<section class="sidebar-page-container nextbit-blog-page">
    <div class="auto-container">
        <div class="row clearfix">
			<div class="<?php print esc_attr( $blog_column ); ?>">

				<?php if ( have_posts() ): ?>
					<header class="page-header d-none">
						<?php
							the_archive_title( '<h1 class="page-title">', '</h1>' );
							the_archive_description( '<div class="archive-description">', '</div>' );
						?>
					</header><!-- .page-header -->
					<?php
						/* Start the Loop */
						while ( have_posts() ):
							the_post();

							/*
							* Include the Post-Type-specific template for the content.
							* If you want to override this in a child theme, then include a file
							* called content-___.php (where ___ is the Post Type name) and that will be used instead.
							*/
							get_template_part( 'post-formats/content', get_post_type() );
						endwhile;?>
                    <div class="author-navigation">
					<?php
						the_posts_pagination( array(
                            'screen_reader_text' => ' ',
                            'prev_text'  => 'New Posts',
                            'next_text' => 'Old Posts'
                        ) );
                    ?>
                    </div>
                    <?php
						else:
							get_template_part( 'post-formats/content', 'none' );
						endif;
					?>
			</div>
			<?php if ( is_active_sidebar( 'blog-sidebar' ) ): ?>
		        <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
					<aside class="sidebar sticky-top">
						<?php get_sidebar();?>
	            	</aside>
	            </div>
			<?php endif;?>
        </div>
    </div>
</section>
<?php
get_footer();
