<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package nextbit
 */

get_header();

$nextbit_error_404_text = get_theme_mod('nextbit_error_404_text', __('404', 'nextbit'));
$nextbit_error_title = get_theme_mod('nextbit_error_title', __('Oops! That page can’t be found', 'nextbit'));
$nextbit_error_link_text = get_theme_mod('nextbit_error_link_text', __('Back To Home', 'nextbit'));
$nextbit_error_desc = get_theme_mod('nextbit_error_desc', __('Sorry, but the page you are looking for does not existing', 'nextbit'));

?>

<section class="error-section">
	<div class="auto-container">
		<div class="content">

			<?php if(!empty( $nextbit_error_404_text )) : ?>
			<h1><?php print esc_html($nextbit_error_404_text);?></h1>
			<?php endif; ?>

			<?php if(!empty( $nextbit_error_title )) : ?>
			<h2><?php print esc_html($nextbit_error_title);?></h2>
			<?php endif; ?>

			<?php if(!empty( $nextbit_error_desc )) : ?>
			<div class="text"><?php print esc_html($nextbit_error_desc); ?></div>
			<?php endif; ?>

			<?php if(!empty( $nextbit_error_link_text )) : ?>
			<a href="<?php print esc_url(home_url('/'));?>" class="theme-btn btn-style-four">
			<span class="txt"><?php print esc_html($nextbit_error_link_text);?></span></a>
			<?php endif; ?>

		</div>
	</div>
</section>

<?php
get_footer();
