<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class Cve extends \Google\Collection
{
  protected $collection_key = 'references';
  protected $cvssv3Type = Cvssv3::class;
  protected $cvssv3DataType = '';
  public $cvssv3;
  /**
   * @var string
   */
  public $id;
  protected $referencesType = Reference::class;
  protected $referencesDataType = 'array';
  public $references = [];
  /**
   * @var bool
   */
  public $upstreamFixAvailable;

  /**
   * @param Cvssv3
   */
  public function setCvssv3(Cvssv3 $cvssv3)
  {
    $this->cvssv3 = $cvssv3;
  }
  /**
   * @return Cvssv3
   */
  public function getCvssv3()
  {
    return $this->cvssv3;
  }
  /**
   * @param string
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * @param Reference[]
   */
  public function setReferences($references)
  {
    $this->references = $references;
  }
  /**
   * @return Reference[]
   */
  public function getReferences()
  {
    return $this->references;
  }
  /**
   * @param bool
   */
  public function setUpstreamFixAvailable($upstreamFixAvailable)
  {
    $this->upstreamFixAvailable = $upstreamFixAvailable;
  }
  /**
   * @return bool
   */
  public function getUpstreamFixAvailable()
  {
    return $this->upstreamFixAvailable;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Cve::class, 'Google_Service_SecurityCommandCenter_Cve');
