<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Books;

class DictlayerdataDictWordsSensesDefinitions extends \Google\Collection
{
  protected $collection_key = 'examples';
  /**
   * @var string
   */
  public $definition;
  protected $examplesType = DictlayerdataDictWordsSensesDefinitionsExamples::class;
  protected $examplesDataType = 'array';
  public $examples = [];

  /**
   * @param string
   */
  public function setDefinition($definition)
  {
    $this->definition = $definition;
  }
  /**
   * @return string
   */
  public function getDefinition()
  {
    return $this->definition;
  }
  /**
   * @param DictlayerdataDictWordsSensesDefinitionsExamples[]
   */
  public function setExamples($examples)
  {
    $this->examples = $examples;
  }
  /**
   * @return DictlayerdataDictWordsSensesDefinitionsExamples[]
   */
  public function getExamples()
  {
    return $this->examples;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DictlayerdataDictWordsSensesDefinitions::class, 'Google_Service_Books_DictlayerdataDictWordsSensesDefinitions');
