<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class DeviceTierSet extends \Google\Collection
{
  protected $collection_key = 'deviceTiers';
  protected $deviceTiersType = DeviceTier::class;
  protected $deviceTiersDataType = 'array';
  public $deviceTiers = [];

  /**
   * @param DeviceTier[]
   */
  public function setDeviceTiers($deviceTiers)
  {
    $this->deviceTiers = $deviceTiers;
  }
  /**
   * @return DeviceTier[]
   */
  public function getDeviceTiers()
  {
    return $this->deviceTiers;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DeviceTierSet::class, 'Google_Service_AndroidPublisher_DeviceTierSet');
