<?php
/**
 * Plugin Name: All-in-One WP Migration OneDrive Extension
 * Plugin URI: https://servmask.com/
 * Description: Extension for All-in-One WP Migration that enables using OneDrive for imports and exports
 * Author: ServMask
 * Author URI: https://servmask.com/
 * Version: 1.61
 * Text Domain: all-in-one-wp-migration-onedrive-extension
 * Domain Path: /languages
 * Network: True
 *
 * Copyright (C) 2014-2020 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

// Check SSL Mode
if ( isset( $_SERVER['HTTP_X_FORWARDED_PROTO'] ) && ( $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https' ) ) {
	$_SERVER['HTTPS'] = 'on';
}

// Plugin Basename
define( 'AI1WMOE_PLUGIN_BASENAME', basename( dirname( __FILE__ ) ) . '/' . basename( __FILE__ ) );

// Plugin Path
define( 'AI1WMOE_PATH', dirname( __FILE__ ) );

// Plugin URL
define( 'AI1WMOE_URL', plugins_url( '', AI1WMOE_PLUGIN_BASENAME ) );

// Include constants
require_once dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'constants.php';

// Include functions
require_once dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'functions.php';

// Include exceptions
require_once dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'exceptions.php';

// Include loader
require_once dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'loader.php';

// ===========================================================================
// = All app initialization is done in Ai1wmoe_Main_Controller __constructor =
// ===========================================================================
$main_controller = new Ai1wmoe_Main_Controller();

// ==========================================================================
// ============ Fully nulled and tested 100% working by wp.solar ============
// ==========================================================================
add_action(
	'plugins_loaded',
	function() {
		remove_action( 'in_plugin_update_message-' . AI1WMOE_PLUGIN_BASENAME, 'Ai1wm_Updater_Controller::in_plugin_update_message', 10 );
		remove_filter( 'plugin_row_meta', 'Ai1wm_Updater_Controller::plugin_row_meta', 10 );
	},
	20
);
// ==========================================================================
// == WP Solar - Yet another premium WordPress themes and plugins manager. ==
// ==========================================================================
