<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Toroflix
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="Top">
        <?php the_title( '<h1 class="Title entry-title">', '</h1>' ); ?>
    </header>
    <div class="Description">
		<?php
			the_content();

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'toroflix' ),
				'after'  => '</div>',
			) );
		?>
    </div>
    
	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
				edit_post_link(
					sprintf(
						wp_kses(
							__( 'Edit <span class="screen-reader-text">%s</span>', 'toroflix' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						get_the_title()
					),
					'<span class="edit-link">',
					'</span>'
				);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article>