<?php
/* 
* -------------------------------------------------------------------------------------
* @author: Google reCAPTCHA
* @author URI: https://www.google.com/recaptcha/
* @copyright: (c) 2017 Google. All rights reserved
* -------------------------------------------------------------------------------------
*
* @since 1.2.0
*
*/
class ReCaptchaResponse {
    public $success;
    public $errorCodes;
}
class ReCaptcha {
    private static $_signupUrl = "https://www.google.com/recaptcha/admin";
    private static $_siteVerifyUrl = "https://www.google.com/recaptcha/api/siteverify?";
    private $_secret;
    private static $_version = "php_1.0";
    function ReCaptcha($secret) {
        if ($secret == null || $secret == "") {
            die("To use reCAPTCHA you must get an API key from <a href='". self::$_signupUrl . "'>" . self::$_signupUrl . "</a>");
        }
        $this->_secret=$secret;
    }
    private function _encodeQS($data) {
        $req = "";
        foreach ($data as $key => $value) {
            $req .= $key . '=' . urlencode(stripslashes($value)) . '&';
        }
        $req = substr($req, 0, strlen($req)-1);
        return $req;
    }
    private function _submitHTTPGet($path, $data) {
        $req = $this->_encodeQS($data);
		$request  = wp_remote_get( $path . $req );
		$response = wp_remote_retrieve_body( $request );
        return $response;
    }
    public function verifyResponse($remoteIp, $response) {
        if ($response == null || strlen($response) == 0) {
            $recaptchaResponse = new ReCaptchaResponse();
            $recaptchaResponse->success = false;
            $recaptchaResponse->errorCodes = 'missing-input';
            return $recaptchaResponse;
        }
        $getResponse = $this->_submitHttpGet(
            self::$_siteVerifyUrl,
            array (
                'secret' => $this->_secret,
                'remoteip' => $remoteIp,
                'v' => self::$_version,
                'response' => $response
            )
        );
        $answers = json_decode($getResponse, true);
        $recaptchaResponse = new ReCaptchaResponse();
        if (trim($answers ['success']) == true) {
            $recaptchaResponse->success = true;
        } else {
            $recaptchaResponse->success = false;
            $recaptchaResponse->errorCodes = $answers [error-codes];
        }
        return $recaptchaResponse;
    }
}