<?php get_header();
$thumbs = get_option('disable_thumbs_episodes', false);
$term_id  = get_queried_object_id();
$serie_id = get_term_meta($term_id, 'tr_id_post', true);
$term     = get_term_by('id', $term_id, 'seasons');
$slug     = $term->slug; ?>
<div class="bd">
    <section class="section episodes">
        <header class="section-header">
            <div class="aa-drp choose-season">
                <button class="btn lnk npd aa-arrow-right"><a href="<?php echo get_the_permalink($serie_id); ?>"><?php echo get_the_title($serie_id); ?></a> - <?php _e('Season', 'torofilm'); ?><dt class="n_s" style="display: inline"><?php echo get_term_meta($term->term_id, 'season_number', true); ?></dt></button>
            </div>
        </header>
        <ul id="episode_by_temp" class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl8e eqcl">
            <?php $episodes = get_terms('episodes', array(
                'orderby' => 'meta_value_num',
                'order'         => 'ASC',
                'hide_empty'    => 0,
                'number'        => 100,
                'meta_query' => array(
                    'relation' => 'AND',
                    array(
                        'key' => 'episode_number',
                        'compare' => 'EXISTS',
                    ),
                    array(
                        'key' => 'tr_id_post',
                        'value' => get_the_ID()
                    ),
                    array(
                        'key' => 'season_number',
                        'value' => get_term_meta($term->term_id, 'season_number', true)
                    )
                )
            ));
            if ($episodes) {
                foreach ($episodes as $episode) {
                    $air_date = get_term_meta($episode->term_id, 'air_date', true);
                    $dat = strtotime($air_date); ?>
                    <li>
                        <article class="post dfx fcl episodes fa-play-circle lg">
                            <?php if (!$thumbs) { ?>
                                <div class="post-thumbnail">
                                    <figure><?php echo tr_theme_img($episode->term_id, 'episode', $episode->name, $episode->taxonomy); ?></figure>
                                </div>
                            <?php } ?>
                            <header class="entry-header">
                                <span class="num-epi"><?php echo get_term_meta($episode->term_id, 'season_number', true); ?>x<?php echo get_term_meta($episode->term_id, 'episode_number', true); ?></span>
                                <h2 class="entry-title"><?php echo $episode->name; ?></h2>
                                <div class="entry-meta">
                                    <span class="time"><?php echo human_time_diff($dat, current_time('timestamp')) . ' ' . __('ago', 'torofilm'); ?></span>
                                </div>
                                <span class="view"><?php _e('View', 'torofilm'); ?></span>
                            </header>
                            <a href="<?php echo get_term_link($episode); ?>" class="lnk-blk"></a>
                        </article>
                    </li>
                <?php }
            } else { ?>
                <p><?php _e('No results found', 'torofilm'); ?></p>
            <?php } ?>
        </ul>
    </section>
</div>
<?php
get_footer(); ?>