<?php
add_action('widgets_init', function () {
	register_widget('widget_list_episodes');
});
class widget_list_episodes extends WP_Widget
{
	#Sets up the widgets name etc
	public function __construct()
	{
		$widget_ops = array(
			'classname' => 'widget_list_episodes',
			'description' => 'Widget list of episodes',
		);
		parent::__construct('widget_list_episodes', 'Torofilm: List of episodes', $widget_ops);
	}
	# Display frontend
	public function widget($argus, $instance)
	{
		$thumbs = get_option('disable_thumbs_episodes', false);
		echo $argus['before_widget']; ?>
		<?php $url = (!empty($instance['url'])) ? $instance['url'] : false; ?>
		<header class="section-header">
			<div class="rw alg-cr jst-sb">
				<h3 class="section-title"><?php echo $instance['title']; ?></h3>
				<?php if ($url) { ?>
					<ul class="rw">
						<li><a href="<?php echo $url; ?>" class="btn lnk more fa-plus"><?php _e('Read more', 'torofilm'); ?></a></li>
					</ul>
				<?php } ?>
			</div>
		</header>
		<ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e eqcl">
			<?php $number = (!empty($instance['number'])) ? absint($instance['number']) : 5;
			$episodes = get_terms('episodes', array(
				'orderby'    	=> 'id',
				'order' 		=> 'DESC',
				'hide_empty' 	=> 0,
				'number' 		=> $number
			));
			foreach ($episodes as $episode) {
				$air_date = get_term_meta($episode->term_id, 'air_date', true);
				$dat = strtotime($air_date); ?>
				  <?php
                            $ntempx = get_term_meta($episode->term_id, 'season_number', true);
                             
                        if(!$ntempx) {
                        
                            $ntempx = 0;
                        }  ?>
				<li>
					<article class="post dfx fcl episodes fa-play-circle">
						<?php if (!$thumbs) { ?>
							<div class="post-thumbnail">
								<figure><?php echo tr_theme_img($episode->term_id, 'episode', $episode->name, $episode->taxonomy); ?></figure>
								<span class="play fa-play"></span>
							</div>
						<?php } ?>
						<header class="entry-header">
							<span class="num-epi"><?php echo $ntempx; ?>x<?php echo get_term_meta($episode->term_id, 'episode_number', true); ?></span>
							<h2 class="entry-title"><?php echo $episode->name; ?></h2>
							<div class="entry-meta">
								<span class="time"><?php echo human_time_diff($dat, current_time('timestamp')) . ' ago'; ?></span>
							</div>
						</header>
						<a href="<?php echo get_term_link($episode); ?>" class="lnk-blk"></a>
					</article>
				</li>
			<?php } ?>
		</ul>
	<?php echo $argus['after_widget'];
	}
	#Parameters Form of Widget
	public function form($instance)
	{
		$title  = !empty($instance['title']) ? $instance['title'] : '';
		$number = isset($instance['number']) ? absint($instance['number']) : 5;
		$url = !empty($instance['url']) ? $instance['url'] : '';
	?>
		<div class="wdgt-tt">
			<div>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'torofilm'); ?>:</label>
				<div class="fr-input">
                    <span class="dashicons dashicons-edit-large"></span>
					<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
					</div>
			</div>
			<div>
				<label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of items', 'torofilm'); ?>:</label>
				<div class="fr-input">
                    <span class="dashicons dashicons-shortcode"></span>
					<input style="width: 100px;" class="tiny-text" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="number" step="1" min="1" value="<?php echo $number; ?>" size="3" />
				</div>
			</div>
			<div>
				<label for="<?php echo $this->get_field_id('url'); ?>">URL</label>
				<div class="fr-input">
                    <span class="dashicons dashicons-admin-links"></span>
					<input class="widefat" id="<?php echo $this->get_field_id('url'); ?>" name="<?php echo $this->get_field_name('url'); ?>" type="text" value="<?php echo esc_attr($url); ?>">
				</div>
			</div>
		</div>
<?php
	}
	#Save Data
	public function update($new_instance, $old_instance)
	{
		// processes widget options to be saved
		foreach ($new_instance as $key => $value) {
			$updated_instance[$key] = sanitize_text_field($value);
		}
		return $updated_instance;
	}
}
