<?php 
add_action( 'widgets_init', function(){
    register_widget( 'wdgt_letter' );
});
class wdgt_letter extends WP_Widget {
    #Sets up the widgets name etc
    public function __construct() {
        $widget_ops = array(
            'classname' => 'wdgt_letter',
            'description' => 'Letter for movies and series',
        );
        parent::__construct( 'wdgt_letter', 'Torofilm Letter', $widget_ops );
    }
    # Display frontend
    public function widget( $argus, $instance ) {
        echo $argus['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $argus['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $argus['after_title'];
        } ?>
        <!-- Add contenido -->
        <ul class="az-lst dfx fwp">
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/0-9">#</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/A">A</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/B">B</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/C">C</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/D">D</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/E">E</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/F">F</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/G">G</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/H">H</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/I">I</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/J">J</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/K">K</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/L">L</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/M">M</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/N">N</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/O">O</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/P">P</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/Q">Q</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/R">R</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/S">S</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/T">T</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/U">U</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/V">V</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/W">W</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/X">X</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/Y">Y</a></li>
            <li><a class="btn sm blk" href="<?php echo esc_url( home_url() ); ?>/letter/Z">Z</a></li>
        </ul>
        <?php echo $argus['after_widget'];
    }
    #Parameters Form of Widget
    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        ?>
            <div class="wdgt-tt">
                <div>
                    <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title', 'torofilm'); ?>:</label>
                    <div class="fr-input">
                        <span class="dashicons dashicons-edit-large"></span>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
                    </div>
                </div>
            </div>
        <?php
    }
    #Save Data
    public function update( $new_instance, $old_instance ) {
        // processes widget options to be saved
        foreach( $new_instance as $key => $value )
        {
            $updated_instance[$key] = sanitize_text_field($value);
        }
        return $updated_instance;
    }
}