<?php get_header();
$curauth = (get_query_var('author_name')) ? get_user_by('slug', get_query_var('author_name')) : get_userdata(get_query_var('author'));  
$favoritos = get_user_meta( $curauth->ID, 'favorito', true); 
if(!$favoritos)
	$favoritos = array();
$favoritos_s = get_user_meta( $curauth->ID, 'favorito-s', true); 
if(!$favoritos_s)
	$favoritos_s = array();
?>	
	<div class="bd">
		<section class="section profile">
			<header class="section-header dfxa alg-cr">
				<div class="user-box dfx alg-cr fg1">
					<figure class="avatar fa-user alg-ss">
						<?php echo get_avatar( $curauth->ID ); ?>
					</figure>
					<aside class="fg1">
						<h1 class="section-title"><?php echo $curauth->nickname; ?></h1>
						<?php if($curauth->description){ ?>
							<p class="about-me"><?php echo $curauth->description; ?></p>
						<?php } else { ?>
							<p class="about-me"><?php _e("You haven't written anything about yourself", 'torofilm'); ?></p>
						<?php } ?>
					</aside>
				</div>
				<div class="stats">
					<ul class="rw stats-li">
						<li><?php echo (count($favoritos) + count($favoritos_s)); ?> <span><?php _e('Favorites', 'torofilm'); ?></span></li>
					</ul>
				</div>
			</header>
			<ul class="aa-tbs dfx" data-tbs="aa-profile">
				<li><a href="#profile-a" class="on"><?php _e('Movies', 'torofilm'); ?></a></li>
				<li><a href="#profile-d"><?php _e('Series', 'torofilm'); ?></a></li>
				<li><a href="#profile-c"><?php _e('Episodes', 'torofilm'); ?></a></li>
				<li><a href="#profile-b"><?php _e('Settings', 'torofilm'); ?></a></li>
			</ul>
		</section>
		<div class="aa-cn" id="aa-profile">
			<div id="profile-a" class="aa-tb anm-b hdd on">
				<!-- movies -->
				<section class="section movies">
					<header class="section-header dfx alg-cr">
						<h3 class="section-title"><?php _e('Favorites Movies', 'torofilm'); ?></h3>
					</header>
					<?php if($favoritos){ ?>
						<ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e">
							<?php 
						    $args = array(
						        'post_type' => array('movies'),
						        'post__in' => $favoritos,  
						    ); 
						    $the_query = new WP_Query( $args );
						    if ( $the_query->have_posts() ) :
						        while ( $the_query->have_posts() ) : $the_query->the_post(); 
						        	get_template_part( 'public/partials/template/movies', 'mainbig' );
								endwhile;
							else: ?>
								<p><?php _e('No results', 'torofilm'); ?></p>
							<?php endif; wp_reset_query(); ?>
						</ul>
					<?php } else { ?>
						<p><?php _e('No results', 'torofilm'); ?></p>
					<?php } ?>
				</section>
			</div>
			<div id="profile-d" class="aa-tb anm-b hdd">
				<!-- movies -->
				<section class="section movies">
					<header class="section-header dfx alg-cr">
						<h3 class="section-title"><?php _e('Favorites Series', 'torofilm'); ?></h3>
					</header>
					<?php if($favoritos){ ?>
						<ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e">
							<?php 
						    $args = array(
						        'post_type' => array( 'series'),
						        'post__in' => $favoritos,  
						    ); 
						    $the_query = new WP_Query( $args );
						    if ( $the_query->have_posts() ) :
						        while ( $the_query->have_posts() ) : $the_query->the_post(); 
						        	get_template_part( 'public/partials/template/movies', 'mainbig' );
								endwhile;
							else: ?>
								<p><?php _e('No results', 'torofilm'); ?></p>
							<?php endif; wp_reset_query(); ?>
						</ul>
					<?php } else { ?>
						<p><?php _e('No results', 'torofilm'); ?></p>
					<?php } ?>
				</section>
			</div>
			<div id="profile-c" class="aa-tb anm-b hdd">
				<!-- movies -->
				<section class="section movies">
					<header class="section-header dfx alg-cr">
						<h3 class="section-title"><?php _e('Favorites Episodes', 'torofilm'); ?></h3>
					</header>
					<?php if($favoritos_s){ ?>
						<ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e eqcl">
							<?php $episodes = get_terms( 'episodes', array(
								'include' => $favoritos_s
							) ); 
							foreach ( $episodes as $episode ) {  
								$air_date = get_term_meta( $episode->term_id, 'air_date', true );
								$dat = strtotime($air_date); ?>
								<li>
									<article class="post dfx fcl episodes fa-play-circle">
										<header class="entry-header">
											<span class="num-epi"><?php echo get_term_meta($episode->term_id, 'season_number', true); ?>x<?php echo get_term_meta($episode->term_id, 'episode_number', true); ?></span> <h2 class="entry-title"><?php echo $episode->name; ?></h2>
											<div class="entry-meta">
												<span class="time"><?php echo human_time_diff( $dat, current_time('timestamp') ) . ' ago'; ?></span>
											</div>
										</header>
										<a href="<?php echo get_term_link( $episode ); ?>" class="lnk-blk"></a>
									</article>
								</li>
							<?php } ?>	
						</ul>
					<?php } else { ?>
						<p><?php _e('No results', 'torofilm'); ?></p>
					<?php } ?>
				</section>
			</div>
			<div id="profile-b" class="aa-tb anm-b hdd">
				<section class="edit-profile">
					<header class="section-header dfxb alg-cr">
						<h3 class="section-title"><?php _e('Edit profile', 'torofilm'); ?></h3>
					</header>
					<form id="editor-user-perfil" enctype="multipart/form-data">					
						
						<ul class="rw rcl1 rcl2a">
							<li>
								<p class="inp">
									<label><?php _e('Country', 'torofilm'); ?></label>
									<input value="<?php echo get_user_meta($current_user->ID, 'pais', true); ?>" type="text" id="edit-user-perfil-pais" name="edit-user-perfil-pais" data-countrycodeinput="1" readonly="readonly" placeholder="<?php _e('Select your country', 'torofilm'); ?>" />
								</p>
							</li>
							<li>
								<p class="inp">
									<label><?php _e('Date of birth', 'torofilm'); ?></label>
									<input name="edit-user-perfil-nacimiento" id="edit-user-perfil-nacimiento" type="date" value="<?php echo get_user_meta($current_user->ID, 'nacimiento', true); ?>">
								</p>
							</li>
						</ul>
						<p class="inp">
							<label><?php _e('About you', 'torofilm'); ?></label>
							<textarea cols="6" name="edit-user-perfil-description" id="edit-user-perfil-description"><?php echo $current_user->user_description; ?></textarea>
						</p>
						<p><button type="submit" class="btn snd blk"><?php _e('Save Changes', 'torofilm'); ?></button></p>
					</form>
					<form id="editor-user-pass">
						<hr>
						<header class="section-header dfxb alg-cr">
							<h3 class="section-title"><?php _e('Change password', 'torofilm'); ?></h3>
						</header>
						<p class="inp val-ok">
							<label><?php _e('Current password', 'torofilm'); ?></label>
							<span class="ico">
								<input type="text" id="password current">
								<i class="fa-lock"></i>
							</span>
							<!-- <span class="val fa-check">success</span> -->
						</p>
						<p class="inp val-ok">
							<label><?php _e('New password', 'torofilm'); ?></label>
							<span class="ico">
								<input required id="editor-user-pass-password" type="password">
								<i class="fa-lock"></i>
							</span>
							<!-- <span class="val fa-check">success</span> -->
						</p>
						<p class="inp val-no">
							<label><?php _e('Repeat password', 'torofilm'); ?></label>
							<span class="ico">
								<input required id="editor-user-pass-repeat" type="password">
								<!-- <i class="fa-lock"></i> -->
							</span>
							<!-- <span class="val fa-times">error</span> -->
						</p>
						<p><button type="submit" class="btn snd blk"><?php _e('Update Password', 'torofilm'); ?></button></p>
					</form>
				</section>
			</div>
		</div>
	</div>
<?php get_footer(); ?>