<?php 
/*Carousel Letter*/
if ( ! function_exists( 'season_content_carousel' ) ) {
	function season_content_carousel() { 
		$alphabet = get_option('alphabet_show');
        if($alphabet){
	        	get_template_part('public/partials/template/letters');
	        }
	}
}
add_action( 'season_content', 'season_content_carousel', 10 );


/*Info Episode*/
if ( ! function_exists( 'season_content_info' ) ) {
	function season_content_info($data) { 
		$term           = $data['term']; 
		$url            = get_term_link( $term );
		$term_id        = $data['term_id']; 
		
		$season         = new TOROFLIX_Seasons;
		$serie_id       = $season->get_serie_id($term_id);
		$director       = $season->director_term($term_id);
		$cast           = $season->casts_term($term_id);
		$genre          = $season->categories_term($term_id);
		$season_current = $season->number_season_term($term_id);
		$year           = $season->year_term($term_id); 
		$listEpisodes   = $season->get_episodes_by_season($term_id);

		$sidebar_position = TOROFLIX_Add_Theme_Support::get_position_sidebar();  
		
		?>
		<div class="TpRwCont <?php echo $sidebar_position; ?>">
            <main>
            	<?php 
            	
            	get_template_part( 'public/partials/template/season/season', 'info', array( 'term' => $term, 'term_id' => $term_id, 'url' => $url ) );

            	get_template_part( 'public/partials/template/season/season', 'list', array( 'term' => $term, 'term_id' => $term_id ) );
            	
            	?>
            </main>
            <?php get_sidebar(); ?>
        </div>
	<?php }
}
add_action( 'season_content', 'season_content_info', 20 );

if ( ! function_exists( 'season_content_related' ) ) {
	function season_content_related($data) {
		$id = $data['serie_id'];
		$custom_taxterms = wp_get_object_terms( $id, 'category', array('fields' => 'ids') );
        $args = array(
            'post_type' => 'series',
		    'post_status' => 'publish',
		    'posts_per_page' => 15,
		    'orderby' => 'rand',
		    'tax_query' => array(
		        array(
		            'taxonomy' => 'category',
		            'field' => 'id',
		            'terms' => $custom_taxterms
		        )
		    ),
		    'post__not_in' => array($id),
        ); 
        $the_query = new WP_Query( $args );
        if ( $the_query->have_posts() ) : ?>
			<section>
			    <div class="Top AAIco-movie_filter">
			        <div class="Title"><?php _e('More titles like this', 'toroflix'); ?></div>
			    </div>
			    <div class="MovieListTop owl-carousel Serie">
			        <?php while ( $the_query->have_posts() ) : $the_query->the_post(); 
			        	get_template_part('public/partials/template/loop', 'secondary');
			        endwhile; ?>
			    </div>
			</section>
		<?php endif; wp_reset_query();
	}
}
add_action( 'season_content', 'season_content_related', 30 );