<?php 
function sticky_post_get_meta( $value ) {
	global $post;
	$field = get_post_meta( $post->ID, $value, true );
	if ( ! empty( $field ) ) {
		return is_array( $field ) ? stripslashes_deep( $field ) : stripslashes( wp_kses_decode_entities( $field ) );
	} else {
		return false;
	}
}
function sticky_post_add_meta_box() {
	add_meta_box(
		'sticky_post-sticky-post',
		__( 'Sticky Post', 'sticky_post' ),
		'sticky_post_html',
		'movies',
		'side',
		'high'
	);
	add_meta_box(
		'sticky_post-sticky-post',
		__( 'Sticky Post', 'sticky_post' ),
		'sticky_post_html',
		'series',
		'side',
		'high'
	);
}
add_action( 'add_meta_boxes', 'sticky_post_add_meta_box' );
function sticky_post_html( $post) {
	wp_nonce_field( '_sticky_post_nonce', 'sticky_post_nonce' ); ?>
	<p>
		<input type="checkbox" name="sticky_post_sticky_post" id="sticky_post_sticky_post" value="sticky-post" <?php echo ( sticky_post_get_meta( 'sticky_post_sticky_post' ) === 'sticky-post' ) ? 'checked' : ''; ?>>
		<label for="sticky_post_sticky_post"><?php _e( 'Sticky post', 'sticky_post' ); ?></label>	</p><?php
}
function sticky_post_save( $post_id ) {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if ( ! isset( $_POST['sticky_post_nonce'] ) || ! wp_verify_nonce( $_POST['sticky_post_nonce'], '_sticky_post_nonce' ) ) return;
	if ( ! current_user_can( 'edit_post', $post_id ) ) return;
	if ( isset( $_POST['sticky_post_sticky_post'] ) )
		update_post_meta( $post_id, 'sticky_post_sticky_post', esc_attr( $_POST['sticky_post_sticky_post'] ) );
	else
		update_post_meta( $post_id, 'sticky_post_sticky_post', null );
}
add_action( 'save_post', 'sticky_post_save' );
/*
	Usage: sticky_post_get_meta( 'sticky_post_sticky_post' )
*/
