<?php 
add_action( 'widgets_init', function(){
    register_widget( 'navigation_widget_toroflix' );
});
class navigation_widget_toroflix extends WP_Widget {
    #Sets up the widgets name etc
    public function __construct() {
        $widget_ops = array(
            'classname' => 'widget_nav_menu',
            'description' => 'show navigation',
        );
        parent::__construct( 'navigation_widget_toroflix', 'Toroflix: Navigation', $widget_ops );
    }
    # Display frontend
    public function widget( $argus, $instance ) {
        echo $argus['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $argus['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $argus['after_title'];
        } 
        $menu = isset( $instance['menu'] ) ? $instance['menu'] : false; ?>
        <div class="menu-sidebar-container">
            <?php 
                wp_nav_menu(
                    array(
                        'menu'       => $menu,
                        'container'  =>  false,
                        'items_wrap' =>  '<ul id="menu-sidebar" class="menu">%3$s</ul>',
                    )
                );
            ?>
        </div>
        <?php echo $argus['after_widget'];
    }
    #Parameters Form of Widget
    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $menu = isset( $instance['menu'] ) ? $instance['menu'] : false;
        ?>
        <div class="wdgt-tt">
            <div>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'toroflix' ); ?></label>
                <div class="fr-input">
                    <span class="dashicons dashicons-edit-large"></span>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
                </div>
                    
            </div>
            <div>
                <label for="<?php echo $this->get_field_id('menu'); ?>"><?php _e('Select menu', 'toroflix'); ?></label>

                <?php $menus = get_terms('nav_menu');
                if($menus){ ?>
                    <div class="fr-input">
                        <span class="dashicons dashicons-sort"></span>
                        <select id="<?php echo $this->get_field_id('menu'); ?>" name="<?php echo $this->get_field_name('menu'); ?>">
                            <?php
                            foreach($menus as $key => $men){ ?>
                                <option<?php selected( $menu, $men->slug ); ?> value="<?php echo $men->slug; ?>"><?php echo $men->name; ?></option>
                            <?php }
                            ?>
                        </select>
                    </div>
                <?php } else { ?>
                    <p><?php _e('You have not created any menu yet', 'toroflix'); ?>. <a href="<?php echo admin_url('nav-menus.php'); ?>"><?php _e('Create', 'torofilm'); ?></a></p>
                <?php } ?>
            </div>
        </div>
        <?php
    }
    #Save Data
    public function update( $new_instance, $old_instance ) {
        // processes widget options to be saved
        foreach( $new_instance as $key => $value )
        {
            $updated_instance[$key] = sanitize_text_field($value);
        }
        return $updated_instance;
    }
}
