<?php
# SECTION MOVIES
if (!function_exists('home_section_movies')) {
	function home_section_movies()
	{
		$url_more = rwmb_meta('home_movie_url', array('object_type' => 'setting'), 'theme_option');
		$categories = rwmb_meta('groupe_categories', array('object_type' => 'setting'), 'theme_option'); ?>
		<section class="section movies">
			<header class="section-header">
				<div class="rw alg-cr jst-sb">
					<h1 class="section-title"><?php _e('Film Box Office', 'torofilm'); ?></h1>
					<ul class="rw">
						<li><a href="<?php echo $url_more; ?>" class="btn lnk more fa-plus"><?php _e('See more', 'torofilm'); ?></a></li>
					</ul>
				</div>
				<ul class="aa-tbs ax-tbs" data-tbs="aa-movies">
					<li><a data-category="all" data-type="1" data-post="movies" href="#movies-a" class="on"><?php _e('Last', 'torofilm');  ?></a></li>
					<?php if (!empty($categories)) {
						foreach ($categories as $key => $group_value) {
							$id = isset($group_value['category_selected']) ? $group_value['category_selected'] : '';
							$cate = get_term_by('id', $id, 'category'); ?>
							<li><a data-category="<?php echo $id; ?>" data-type="1" data-post="movies" href="#movies-<?php echo $cate->name; ?>"><?php echo $cate->name; ?></a></li>
					<?php }
					} ?>
				</ul>
			</header>
			<div class="aa-cn" id="aa-movies">
				<!-- a -->
				<div id="movies-a" class="aa-tb hdd on">
					<ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e">
						<?php
						$args = array(
							'post_type' => 'movies',
							'posts_per_page' => 12,
						);
						$the_query = new WP_Query($args);
						if ($the_query->have_posts()) :
							while ($the_query->have_posts()) : $the_query->the_post();
								get_template_part('public/partials/template/movies', 'main');
							endwhile;
						endif;
						wp_reset_query(); ?>
					</ul>
				</div>
				<?php if (!empty($categories)) {
					foreach ($categories as $key => $group_value) {
						$id = isset($group_value['category_selected']) ? $group_value['category_selected'] : '';
						$cate = get_term_by('id', $id, 'category'); ?>
						<div id="movies-<?php echo $cate->name; ?>" class="aa-tb hdd"></div>
				<?php }
				} ?>
			</div>
		</section>
	<?php }
}
add_action('home_section', 'home_section_movies', 10);
# SECTION EPISODES
if (!function_exists('home_section_episodes')) {
	function home_section_episodes()
	{ ?>
		<!-- episodes -->
		<section class="section episodes">
			<header class="section-header">
				<div class="rw alg-cr jst-sb">
					<h3 class="section-title"><?php _e('Last Episodes', 'torofilm'); ?></h3>
				</div>
			</header>
			<ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e eqcl">
				<?php $episodes = get_terms('episodes', array(
					'orderby'    	=> 'id',
					'order' 		=> 'DESC',
					'hide_empty' 	=> 0,
					'number' 		=> 12
				));
				foreach ($episodes as $episode) {
					$air_date = get_term_meta($episode->term_id, 'air_date', true);
					$dat = strtotime($air_date); ?>
					<li>
						<article class="post dfx fcl episodes fa-play-circle">
							<header class="entry-header">
								<span class="num-epi"><?php echo get_term_meta($episode->term_id, 'season_number', true); ?>x<?php echo get_term_meta($episode->term_id, 'episode_number', true); ?></span>
								<h2 class="entry-title"><?php echo $episode->name; ?></h2>
								<div class="entry-meta">
									<span class="time"><?php echo human_time_diff($dat, current_time('timestamp')) . ' ago'; ?></span>
								</div>
							</header>
							<a href="<?php echo get_term_link($episode); ?>" class="lnk-blk"></a>
						</article>
					</li>
				<?php } ?>
			</ul>
		</section>
	<?php }
}
add_action('home_section', 'home_section_episodes', 20);
# SECTION SERIES
if (!function_exists('home_section_series')) {
	function home_section_series()
	{
		$url_more = rwmb_meta('home_serie_url', array('object_type' => 'setting'), 'theme_option');
		$categories = rwmb_meta('groupe_categories_serie', array('object_type' => 'setting'), 'theme_option'); ?>
		<!-- series -->
		<section class="section series">
			<header class="section-header">
				<div class="rw alg-cr jst-sb">
					<h3 class="section-title"><?php _e('Serie Box Office', 'torofilm'); ?></h3>
					<ul class="rw">
						<li><a href="<?php echo $url_more; ?>" class="btn lnk more fa-plus"><?php _e('See more', 'torofilm'); ?></a></li>
					</ul>
				</div>
				<ul class="aa-tbs ax-tbs" data-tbs="aa-series">
					<li><a data-category="all" data-type="1" data-post="series" href="#series-a" class="on"><?php _e('Last', 'torofilm'); ?></a></li>
					<?php if (!empty($categories)) {
						foreach ($categories as $key => $group_value) {
							$id = isset($group_value['category_selected']) ? $group_value['category_selected'] : '';
							$cate = get_term_by('id', $id, 'category'); ?>
							<li><a data-category="<?php echo $id; ?>" data-type="1" data-post="series" href="#series-<?php echo $cate->name; ?>"><?php echo $cate->name; ?></a></li>
					<?php }
					} ?>
				</ul>
			</header>
			<div class="aa-cn" id="aa-series">
				<!-- a -->
				<div id="series-a" class="aa-tb hdd on">
					<ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e">
						<?php
						$args = array(
							'post_type' => 'series',
							'posts_per_page' => 12,
						);
						$the_query = new WP_Query($args);
						if ($the_query->have_posts()) :
							while ($the_query->have_posts()) : $the_query->the_post();
								get_template_part('public/partials/template/movies', 'main');
							endwhile;
						endif;
						wp_reset_query(); ?>
					</ul>
				</div>
				<?php if (!empty($categories)) {
					foreach ($categories as $key => $group_value) {
						$id = isset($group_value['category_selected']) ? $group_value['category_selected'] : '';
						$cate = get_term_by('id', $id, 'category'); ?>
						<div id="series-<?php echo $cate->name; ?>" class="aa-tb hdd"></div>
				<?php }
				} ?>
			</div>
		</section>
<?php }
}
add_action('home_section', 'home_section_series', 30);
