<?php
/* PAGINATION */
function torofilm_pagination()
{
    if (is_singular())
        return;
    global $wp_query;
    if ($wp_query->max_num_pages <= 1)
        return;
    $paged = get_query_var('paged') ? absint(get_query_var('paged')) : 1;
    $max   = intval($wp_query->max_num_pages);
    if ($paged >= 1)
        $links[] = $paged;
    if ($paged >= 3) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }
    if (($paged + 2) <= $max) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }
    echo '<div class="nav-links">' . "\n";
    if (get_previous_posts_link())
        printf('%s' . "\n", get_previous_posts_link(__('PREV', 'torofilm')));
    if (!in_array(1, $links)) {
        $class = 1 == $paged ? ' class="page-item active"' : '';
        printf('<a class="page-link" href="' . get_pagenum_link(1) . '">1</a>' . "\n", $class, esc_url(get_pagenum_link(1)), '1');
        if (!in_array(2, $links))
            echo '<a>...</a>';
    }
    sort($links);
    foreach ((array) $links as $link) {
        $class = $paged == $link ? ' class="page-link current"' : '';
        printf('<a%s class="page-link" href="' . get_pagenum_link($link) . '">' . $link . '</a>' . "\n", $class, esc_url(get_pagenum_link($link)), $link);
    }
    if (!in_array($max, $links)) {
        if (!in_array($max - 1, $links))
            echo '<a href="javascript:void(0)" class="extend">...</a>' . "\n";
        $class = $paged == $max ? ' class="page-item active"' : '';
        printf('<a class="page-link" href="' . get_pagenum_link($max) . '">' . $max . '</a>' . "\n", $class, esc_url(get_pagenum_link($max)), $max);
    }
    if (get_next_posts_link())
        printf('%s' . "\n", get_next_posts_link(__('NEXT', 'torofilm')));
    echo '</div>' . "\n";
}
/* PLAYER LINKS DOWNLOAD AND IFRAME */
function tr_links_movies($post_id)
{
    $links_total = get_post_meta($post_id, 'trgrabber_tlinks', true) == '' ? 0 : get_post_meta($post_id, 'trgrabber_tlinks', true) - 1;
    $links = array();
    if (isset($links_total)) {
        for ($i = 0; $i <= $links_total; $i++) {
            $link = unserialize(get_post_meta($post_id, 'trglinks_' . $i, true));
            $type = $link['type'] == '' ? 1 : $link['type'];
            $lang = $link['lang'] == '' ? 0 : $link['lang'];
            $quality = $link['quality'] == '' ? 0 : $link['quality'];
            $server = $link['server'] == '' ? 0 : $link['server'];
            $linkk = $link['link'] == '' ? '' : trgrabber_base64de($link['link']);
            $date = $link['date'] == '' ? '' : $link['date'];
            if ($type == 1 and $linkk != '') {
                $links['online'][] = array(
                    'i' => $i,
                    'lang' => $lang,
                    'quality' => $quality,
                    'server' => $server,
                    'link' => $linkk,
                    'date' => $date
                );
            } elseif ($linkk != '') {
                $links['downloads'][] = array(
                    'i' => $i,
                    'lang' => $lang,
                    'quality' => $quality,
                    'server' => $server,
                    'link' => $linkk,
                    'date' => $date
                );
            }
        }
        return $links;
    } 
}
function tr_links_episodes($term_id)
{
    $links_total = get_term_meta($term_id, 'trgrabber_tlinks', true) == '' ? 0 : get_term_meta($term_id, 'trgrabber_tlinks', true) - 1;
    $links = array();
    if (get_term_meta($term_id, 'trgrabber_tlinks', true) > 0) {
        for ($i = 0; $i <= $links_total; $i++) {
            $link = unserialize(get_term_meta($term_id, 'trglinks_' . $i, true));
            $type = $link['type'] == '' ? 1 : $link['type'];
            $lang = $link['lang'] == '' ? 0 : $link['lang'];
            $quality = $link['quality'] == '' ? 0 : $link['quality'];
            $server = $link['server'] == '' ? 0 : $link['server'];
            $linkk = $link['link'] == '' ? '' : trgrabber_base64de($link['link']);
            $date = $link['date'] == '' ? '' : $link['date'];
            if ($type == 1 and $linkk != '') {
                $links['online'][] = array(
                    'i' => $i,
                    'lang' => $lang,
                    'quality' => $quality,
                    'server' => $server,
                    'link' => $linkk,
                    'date' => $date
                );
            } elseif ($linkk != '') {
                $links['downloads'][] = array(
                    'i' => $i,
                    'lang' => $lang,
                    'quality' => $quality,
                    'server' => $server,
                    'link' => $linkk,
                    'date' => $date
                );
            }
        }
        return $links;
    }
}
function tr_check_type($id, $display = NULL)
{
    $return = '';
    $type = get_post_meta($id, 'tr_post_type', true);
    if ($type == 2) {
        $return = 2;
    } else {
        $return = 1;
    }
    if ($display == NULL) {
        return $return;
    } else {
        echo $return;
    }
}
/*AVATAR USER*/
/*function mytheme_get_avatar($avatar, $id_or_email)
{
    $imagenp = get_user_meta($id_or_email, 'foto_back', true);
    $imagenp = str_replace('.png', '-100x100.png', $imagenp);
    $imagenp = str_replace('.jpg', '-100x100.jpg', $imagenp);
    $imagenp = str_replace('.jpeg', '-100x100.jpeg', $imagenp);
    if ($imagenp) {
    } else {
        $imagenp = TOROFILM_DIR_URI . "public/img/cnt/user.svg";
    }
    $avatar = '<img class="avatar" src="' . $imagenp . '">';
    return $avatar;
}
add_filter('get_avatar', 'mytheme_get_avatar', 10, 2);
add_image_size('nus', 100, 100, true);
add_image_size('news', 393, 220, true);
add_image_size('widget', 48, 48, true);
add_image_size('thumbnails', 215, 320, true);*/
/**
 * Add an image function WordPress / TMDB
 */
if (!function_exists('tr_theme_img')) :
    function tr_theme_img($id, $size, $title = NULL, $taxonomy = NULL, $text = 0, $exclude = NULL)
    {
        $return = '';
        if ($taxonomy == 'episodes') { // episodes
            $image_hotlink = get_term_meta($id, 'still_path_hotlink', true);
            $image = get_term_meta($id, 'still_path', true);
            if (isset($image) and !empty($image)) {
                $return = '<img loading="lazy" src="' . wp_get_attachment_url($image) . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
            } elseif (isset($image_hotlink) and !empty($image_hotlink)) {
                if ($size == 'episode') $size = 'w185';
                if ($size == 'episodes') $size = 'w92';
                if (filter_var($image_hotlink, FILTER_VALIDATE_URL) === FALSE) {
                    $return = '<img loading="lazy" src="//image.tmdb.org/t/p/' . $size . $image_hotlink . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
                } else {
                    $return = '<img loading="lazy" src="' . $image_hotlink . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
                }
            }
        } elseif ($taxonomy == 'seasons') { // seasons
            $image_hotlink = get_term_meta($id, 'poster_path_hotlink', true);
            $image = get_term_meta($id, 'poster_path', true);
            if (isset($image) and !empty($image)) {
                $return = '<img loading="lazy" src="' . wp_get_attachment_url($image) . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
            } elseif (isset($image_hotlink) and !empty($image_hotlink)) {
                if ($size == 'thumbnail') $size = 'w185';
                if (filter_var($image_hotlink, FILTER_VALIDATE_URL) === FALSE) {
                    $return = '<img loading="lazy" src="//image.tmdb.org/t/p/' . $size . $image_hotlink . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
                } else {
                    $return = '<img loading="lazy" src="' . $image_hotlink . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
                }
            }
        } else { // posts
            if (get_the_post_thumbnail($id)) {
                $return = get_the_post_thumbnail($id, $size, array( 'loading' => 'lazy'));
            } elseif (get_post_meta($id, TR_GRABBER_POSTER_HOTLINK, true) != '') {
                if ($size == 'thumbnail') $size = 'w185';
                if ($size == 'medium') $size = 'w500';
                if ($size == 'widget') $size = 'w92';
                if (filter_var(get_post_meta($id, TR_GRABBER_POSTER_HOTLINK, true), FILTER_VALIDATE_URL) === FALSE) {
                    $return = '<img loading="lazy" src="//image.tmdb.org/t/p/' . $size . get_post_meta($id, TR_GRABBER_POSTER_HOTLINK, true) . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
                } else {
                    $return = '<img loading="lazy" src="' . get_post_meta($id, TR_GRABBER_POSTER_HOTLINK, true) . '" alt="' . sprintf(__('Image %s', 'torofilm'), get_the_title($id)) . '">';
                }
            }
        }
        return empty($return) ? '<img loading="lazy" src="' . get_template_directory_uri() . '/public/img/cnt/noimg-' . $size . '.png" alt="' . sprintf(__('Image %s', 'torofilm'), $title) . '">' : $return;
    }
endif;
if (!function_exists('tr_backdrop')) :
    /**
     * Prints HTML with background.
     */
    function tr_backdrop($size = 'w780', $post_id = NULL)
    {
        global $post;
        $post_id = $post_id == '' ? $post->ID : $post_id;
        $backdrop_field = get_post_meta($post_id, TR_GRABBER_FIELD_BACKDROP, true);
        $url_backdrop = wp_get_attachment_image_src($backdrop_field, 'full');
        $backdrop_field = $url_backdrop == '' ? '' : '<img loading="lazy" class="TPostBg" src="' . $url_backdrop[0] . '" alt="' . __('Background', 'torofilm') . '">';
        if ($url_backdrop != '') {
            echo $backdrop_field;
        } elseif (get_post_meta($post_id, TR_GRABBER_FIELD_BACKDROP_HOTLINK, true) != '') {
            echo '<img loading="lazy" class="TPostBg" src="//image.tmdb.org/t/p/' . $size . '' . get_post_meta($post_id, TR_GRABBER_FIELD_BACKDROP_HOTLINK, true) . '" alt="' . __('Background', 'torofilm') . '">';
        } else {
            echo '<img loading="lazy" class="TPostBg" src="' . get_template_directory_uri() . '/img/cnt/w780.png" alt="' . __('Background', 'torofilm') . '">';
        }
    }
endif;
