<?php
if (!class_exists('tp_color_scheme')) {
class tp_color_scheme {
    public function __construct() {
        add_action( 'customize_register', array( $this, 'customizer_register' ) );
        add_action( 'customize_controls_enqueue_scripts', array( $this, 'customize_js' ) );
        add_action( 'customize_controls_print_footer_scripts', array( $this, 'color_scheme_template' ) );
        add_action( 'customize_preview_init', array( $this, 'customize_preview_js' ) );
        add_action( 'wp_head', array( $this, 'output_css' ), 200 );
    }
    public $options = array(
        'tp_color_1',
        'tp_color_2',
        'tp_color_3',
        'tp_color_4',
        'tp_color_5',
        'tp_color_6',
        'tp_color_7',
        'tp_color_8',
        'tp_color_9',
        'tp_color_10',
        'tp_color_11',
        'tp_color_12',
    );
    public function get_color_schemes() {
    return array(
        'default' => array(
            'label'  => __( 'Default', 'torofilm' ),
            'colors' => array(
                '#110920',
                '#fff',
                '#fff',
                '#03C1EF',
                '#03C1EF',
                '#8c3596',
                '#666',
                '#000',
                '#fff',
                '#1B0F30',
                '#311E54',
                '#eee',
            ),
        ),
    );
    }
    public function customizer_register( WP_Customize_Manager $wp_customize ) {
        $wp_customize->add_section( 'tr_colors', array(
           'title' => __( 'Colors', 'torofilm' ),
        ) );
        $color_schemes = $this->get_color_schemes();
        $wp_customize->add_setting( 'color_scheme', array(
            'default' => 'default',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage',
            'capability'     => 'edit_theme_options',
        ) );
        /*$wp_customize->add_control( 'color_scheme', array(
            'label'   => __( 'Color scheme', 'torofilm' ),
            'section' => 'tr_colors',
            'type'    => 'select',
            'choices' => __('Default', 'torofilm'),
        ) );*/
        $options = array(
            'tp_color_1' => __( 'Background Color', 'torofilm' ),
            'tp_color_2' => __( 'Text Color', 'torofilm' ),
            'tp_color_3' => __( 'Links Color', 'torofilm' ),
            'tp_color_4' => __( 'Links Color Hover', 'torofilm' ),
            'tp_color_5' => __( 'Primary Color', 'torofilm' ),
            'tp_color_6' => __( 'Secondary Color', 'torofilm' ),
            'tp_color_7' => __( 'Tertiary Color', 'torofilm' ),
            'tp_color_8' => __( 'Dark Color', 'torofilm' ),
            'tp_color_9' => __( 'Light Color', 'torofilm' ),
            'tp_color_10' => __( 'Gray Color', 'torofilm' ),
            'tp_color_11' => __( 'Gray Dark Color', 'torofilm' ),
            'tp_color_12' => __( 'Gray Light Color', 'torofilm' ),
        );
        $i=0;
        foreach ( $options as $key => $label ) {
            $i++;
            $subtract=$i-1;
            $wp_customize->add_setting( $key, array(
                'sanitize_callback' => 'sanitize_hex_color',
                'transport' => 'postMessage',
                'default' => $color_schemes['default']['colors'][$subtract],
                'capability'     => 'edit_theme_options',
            ) );
            $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $key, array(
                'label' => $label,
                'section' => 'tr_colors',
            ) ) );
        }
    }
    public $is_custom = false;
    public function get_color_scheme() {
        $color_schemes = $this->get_color_schemes();
        $color_scheme  = get_theme_mod( 'trcolor_scheme' );
        $color_scheme  = isset( $color_schemes[$color_scheme] ) ? $color_scheme : 'default';
        if ( 'default' != $color_scheme ) {
          $this->is_custom = true;
        }
        $colors = array_map( 'strtolower', $color_schemes[$color_scheme]['colors'] );
        foreach ( $this->options as $k => $option ) {
          $color = get_theme_mod( $option );
          if ( $color && strtolower( $color ) != $colors[$k] ) {
            $colors[$k] = $color;
            $this->is_custom = true;
          }
        }
        return $colors;
    }
    public function output_css() {
        $colors = $this->get_color_scheme();
        echo '
        <style id="tp_style_css" type="text/css">
            '.$this->get_css( $colors ).'
        </style>
        ';
    }
    public function get_css( $colors ) {
        $css = '
            :root {
              --body:%1$s;
              --text:%2$s;
              --link:%3$s;
              --link-hover:%4$s;
              --primary:%5$s;
              --secondary:%6$s;
              --tertiary:%7$s;
              --dark:%8$s;
              --light:%9$s;
              --gray:%10$s;
              --gray-light:%11$s;
              --gray-dark:%12$s;
            }
        ';
        return str_replace('|', '%', vsprintf( $css, $colors ));
    }
    public function color_scheme_template() {
        $colors = array(
            'tp_color_1' => '{{ data.tp_color_1 }}',
            'tp_color_2' => '{{ data.tp_color_2 }}',
            'tp_color_3' => '{{ data.tp_color_3 }}',
            'tp_color_4' => '{{ data.tp_color_4 }}',
            'tp_color_5' => '{{ data.tp_color_5 }}',
            'tp_color_6' => '{{ data.tp_color_6 }}',
            'tp_color_7' => '{{ data.tp_color_7 }}',
            'tp_color_8' => '{{ data.tp_color_8 }}',
            'tp_color_9' => '{{ data.tp_color_9 }}',
            'tp_color_10' => '{{ data.tp_color_10 }}',
            'tp_color_11' => '{{ data.tp_color_11 }}',
            'tp_color_12' => '{{ data.tp_color_12 }}',
        );
    ?>
    <script type="text/html" id="tmpl-tp-color-scheme">
      <?php echo $this->get_css( $colors ); ?>
    </script>
        <?php
    }
    public function customize_js() {
        wp_enqueue_script( 'tp-color-scheme', get_template_directory_uri() . '/admin/js/color-scheme.js', array( 'customize-controls', 'iris', 'underscore', 'wp-util' ), '1.0', true );
        wp_localize_script( 'tp-color-scheme', 'tpColorScheme', $this->get_color_schemes() );
    }
    public function customize_preview_js() {
        $myvars = array( 
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
        );
        wp_enqueue_script( 'tp-color-scheme-preview', get_template_directory_uri() . '/admin/js/color-scheme-preview.js', array( 'customize-preview' ), '1.0', true );
        wp_localize_script( 'tp-color-scheme-preview', 'trColor', $myvars );
    }
}
}
new tp_color_scheme();