<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.0
 */

get_header();
$streamit_options = get_option('streamit_options');
global $wp_query;
$options_streamit_load = $streamit_options['streamit_display_pagination'];
?>

<div id="primary" class="content-area search-page">
    <main id="main" class="watchlist-contens site-main streamit_datapass" data-options="<?php echo esc_attr($options_streamit_load); ?>">
        <div class="container-fluid">
            <div class="row">
                <?php
                if (have_posts()) :
                    /* Start the Loop */
                    while (have_posts()) : the_post();

                        /**
                         * Run the loop for the search to output the results.
                         * If you want to overload this in a child theme then include a file
                         * called content-search.php and that will be used instead.
                         */
                        get_template_part('template-parts/post/content', 'search');

                    endwhile; // End of the loop.
                ?>
                <?php
                    wp_reset_postdata();
                else : ?>

                    <div class="col-12">
                        <p><?php esc_attr_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'streamit'); ?></p>
                    </div>
                <?php
                endif;
                ?>

            </div>
            <?php
            if (isset($streamit_options['streamit_display_pagination'])) {
                $options = $streamit_options['streamit_display_pagination'];

                if ($options == "load_more") {
                    if ($wp_query->max_num_pages > 1)
                        echo '<a class="streamit_loadmore_btn btn btn-hover iq-button" tabindex="0" data-loading-text="' . $streamit_options['streamit_display_blog_loadmore_text_2'] . '">
                <span data-parallax="scroll">' . $streamit_options['streamit_display_blog_loadmore_text'] . '</span>
            </a>';
                } elseif ($options == "infinite_scroll") {

                    echo '<div class="loader-wheel-container">                                                                   
        </div>';
                } else {
                    streamit_pagination();
                }
            }
            ?>
        </div>

        <?php
        if (class_exists('MasVideos')) {
            if (isset($streamit_options['streamit_display_upcoming'])) {
                if ($streamit_options['streamit_display_upcoming'] == 'yes') {
                    if (in_array('movie', $streamit_options['streamit_upcoming_multi_select'])) {
                        if ($streamit_options['streamit_upcoming_movies_all'] == 'selected') {
                            $args = array(
                                'post_type' => 'movie',
                                'post_status' => 'publish',
                                'post__in' => $streamit_options['streamit_upcoming_movies_selected'],
                            );
                        } else {
                            $args = array(
                                'post_type' => 'movie',
                                'post_status' => 'publish',
                            );
                        }
                        $upcomming_movie = new \WP_Query($args);
                        if ($upcomming_movie->have_posts()) { ?>
                            <div id="iq-upcoming-movie" class="iq-rtl-direction">
                                <div class="container-fluid">
                                    <div class="row">
                                        <div class="col-sm-12 overflow-hidden">
                                            <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                                                <h4 class="main-title">
                                                    <?php if (!empty($streamit_options['streamit_upcoming_title'])) {
                                                        echo esc_attr($streamit_options['streamit_upcoming_title'], 'streamit');
                                                    } else {
                                                        echo __('Upcoming Movies', 'streamit');
                                                    } ?>
                                                </h4>
                                            </div>
                                            <div class="upcoming-contens">
                                                <ul class="inner-slider list-inline row p-0 mb-0">
                                                    <?php
                                                    while ($upcomming_movie->have_posts()) {
                                                        $upcomming_movie->the_post();
                                                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                                                        $trailer_link = get_field('name_trailer_link', get_the_ID());
                                                        $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
                                                        $movie_url_link = get_post_meta(get_the_ID(), '_movie_url_link');
                                                        $movie_choice = get_post_meta(get_the_ID(), '_movie_choice');
                                                        $meta = get_post_meta(get_the_ID());

                                                        $run_time = '';
                                                        $url_link = '';
                                                        $censor_rating = '';
                                                        if (isset($movie_run_time[0])) {
                                                            $run_time = $movie_run_time[0];
                                                        }
                                                        if (isset($movie_censor_rating[0])) {
                                                            $censor_rating = $movie_censor_rating[0];
                                                        }

                                                        if (isset($movie_choice[0])) {
                                                            if ($movie_choice[0] == 'movie_url') {
                                                                $url_link = $movie_url_link[0];
                                                            } else {
                                                                $url_link = get_the_permalink();
                                                            }
                                                        }
                                                        if ($streamit_options['streamit_upcoming_movies_all'] == 'all') {
                                                            if (get_field('key_upcoming', get_the_ID())) {
                                                    ?>
                                                                <li class="slide-item">
                                                                    <div class="block-images position-relative">
                                                                        <div class="img-box">
                                                                            <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="streamit">
                                                                        </div>
                                                                        <div class="block-description">
                                                                            <h6>
                                                                                <a href="<?php echo esc_url($url_link); ?>">
                                                                                    <?php the_title(); ?>
                                                                                </a>
                                                                            </h6>
                                                                            <div class="movie-time d-flex align-items-center my-2">
                                                                                <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating, 'streamit'); ?></div>
                                                                                <span class="text-white"><?php echo esc_html($run_time, 'streamit'); ?></span>
                                                                            </div>
                                                                            <div class="hover-buttons">
                                                                                <a href="<?php echo esc_url($url_link); ?>" class="btn btn-hover iq-button">
                                                                                    <span><i class="fa fa-play mr-1" aria-hidden="true"></i><?php echo esc_html__('Play Now', 'streamit'); ?></span>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="block-social-info">
                                                                            <ul class="list-inline p-0 m-0 music-play-lists">
                                                                                <?php if (isset($streamit_options['streamit_display_social_icons'])) {
                                                                                    if ($streamit_options['streamit_display_social_icons'] == 'yes') {
                                                                                ?>
                                                                                        <li class="share">
                                                                                            <span><i class="ri-share-fill"></i></span>
                                                                                            <div class="share-box">
                                                                                                <div class="d-flex align-items-center">
                                                                                                    <a href="https://www.facebook.com/sharer?u=" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                                                                                    <a href="http://twitter.com/intent/tweet?text=Currentlyreading" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                                                                                    <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                                                                                </div>
                                                                                            </div>
                                                                                        </li>
                                                                                <?php }
                                                                                } ?>
                                                                                <?php if (isset($streamit_options['streamit_display_like'])) {
                                                                                    if ($streamit_options['streamit_display_like'] == 'yes') {
                                                                                ?>
                                                                                        <li>
                                                                                            <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                                                                        </li>
                                                                                <?php }
                                                                                } ?>
                                                                                <li>
                                                                                    <?php
                                                                                    if (!is_user_logged_in()) {
                                                                                        if (isset($streamit_options['streamit_signin_link'])) {
                                                                                            $streamit_signin_link = $streamit_options['streamit_signin_link'];

                                                                                    ?>
                                                                                            <a class="watch-list-not" href="<?php echo esc_url(site_url() . '/' . $streamit_signin_link) ?>">
                                                                                                <span><i class="ri-add-line"></i></span>
                                                                                            </a>
                                                                                        <?php }
                                                                                    } else {
                                                                                        ?>
                                                                                        <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                                                                            <?php
                                                                                            echo add_to_watchlist(get_the_ID());
                                                                                            ?>
                                                                                        </a>
                                                                                    <?php } ?>
                                                                                </li>
                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </li>
                                                            <?php
                                                            }
                                                        } else { ?>
                                                            <li class="slide-item">
                                                                <div class="block-images position-relative">
                                                                    <div class="img-box">
                                                                        <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="streamit">
                                                                    </div>
                                                                    <div class="block-description">
                                                                        <h6>
                                                                            <a href="<?php echo esc_url($url_link); ?>">
                                                                                <?php the_title(); ?>
                                                                            </a>
                                                                        </h6>
                                                                        <div class="movie-time d-flex align-items-center my-2">
                                                                            <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating, 'streamit'); ?></div>
                                                                            <span class="text-white"><?php echo esc_html($run_time, 'streamit'); ?></span>
                                                                        </div>
                                                                        <div class="hover-buttons">
                                                                            <a href="<?php echo esc_url($url_link); ?>" class="btn btn-hover iq-button">
                                                                                <span><i class="fa fa-play mr-1" aria-hidden="true"></i><?php echo esc_html__('Play Now', 'streamit'); ?></span>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                    <div class="block-social-info">
                                                                        <ul class="list-inline p-0 m-0 music-play-lists">
                                                                            <?php if (isset($streamit_options['streamit_display_social_icons'])) {
                                                                                if ($streamit_options['streamit_display_social_icons'] == 'yes') {
                                                                            ?>
                                                                                    <li class="share">
                                                                                        <span><i class="ri-share-fill"></i></span>
                                                                                        <div class="share-box">
                                                                                            <div class="d-flex align-items-center">
                                                                                                <a href="https://www.facebook.com/sharer?u=" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                                                                                <a href="http://twitter.com/intent/tweet?text=Currentlyreading" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                                                                                <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                                                                            </div>
                                                                                        </div>
                                                                                    </li>
                                                                            <?php }
                                                                            } ?>
                                                                            <?php if (isset($streamit_options['streamit_display_like'])) {
                                                                                if ($streamit_options['streamit_display_like'] == 'yes') {
                                                                            ?>
                                                                                    <li>
                                                                                        <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                                                                    </li>
                                                                            <?php }
                                                                            } ?>
                                                                            <li>
                                                                                <?php
                                                                                if (!is_user_logged_in()) {
                                                                                    if (isset($streamit_options['streamit_signin_link'])) {
                                                                                        $streamit_signin_link = $streamit_options['streamit_signin_link'];

                                                                                ?>
                                                                                        <a class="watch-list-not" href="<?php echo esc_url(site_url() . '/' . $streamit_signin_link) ?>">
                                                                                            <span><i class="ri-add-line"></i></span>
                                                                                        </a>
                                                                                    <?php }
                                                                                } else {
                                                                                    ?>
                                                                                    <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                                                                        <?php
                                                                                        echo add_to_watchlist(get_the_ID());
                                                                                        ?>
                                                                                    </a>
                                                                                <?php } ?>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                    <?php }
                                                    }
                                                    ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
        <?php }
                    }
                }
            }
        } ?>
    </main><!-- #main -->
</div><!-- container -->
<?php get_footer();
