<?php
/*
 * Header Options
 */
$opt_name;
Redux::set_section( $opt_name, array(
    'title' => esc_html__('Page Banner Setting','streamit'),
    'id'    => 'breadcrumbs-fevicon',
    'icon'  => 'el el-cog',
    'desc'  => esc_html__('This section contains options for Page Breadcrumbs Area.','streamit'),
    'fields'=> array(

        array(
            'id'       => 'streamit_page_banner_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Default Banner Image','streamit'),
            'read-only'=> false,
            'subtitle' => esc_html__( 'Upload default banner image for your Website. Default will be blank.','streamit'),
        ),

        array(
            'id'      => 'bg_image',
            'type'    => 'image_select',
            'title'   => esc_html__( 'Select Banner Style', 'streamit' ),
            'subtitle' => esc_html__( 'Select the style that best fits your needs.', 'streamit' ),
            'options' => array(
                '1'      => array(
                    'alt' => 'Style1',
                    'img' => get_template_directory_uri() . '/assets/images/backend/bg-1.jpg',
                ),
                '2'      => array(
                    'alt' => 'Style2',
                    'img' => get_template_directory_uri() . '/assets/images/backend/bg-2.jpg',
                ),
                '3'      => array(
                    'alt' => 'Style3',
                    'img' => get_template_directory_uri() . '/assets/images/backend/bg-3.jpg',
                ),
                '4'      => array(
                    'alt' => 'Style4',
                    'img' => get_template_directory_uri() . '/assets/images/backend/bg-4.jpg',
                ),
                '5'      => array(
                    'alt' => 'Style5',
                    'img' => get_template_directory_uri() . '/assets/images/backend/bg-5.jpg',
                ),
            ),
            'default' => '2'
        ),




         array(
            'id' => 'display_banner',
            'type' => 'button_set',
            'title' => esc_html__('Display Banner on inner Pages', 'streamit') ,
            'options' => array(
                'yes' => esc_html__('Yes', 'streamit') ,
                'no' => esc_html__('No', 'streamit')
            ) ,
            'default' => esc_html__('yes', 'streamit')
        ) ,

        array(
            'id' => 'display_breadcrumbs',
            'type' => 'button_set',
            'title' => esc_html__('Display Breadcrumbs on Banner', 'streamit') ,
            'options' => array(
                'yes' => esc_html__('Yes', 'streamit') ,
                'no' => esc_html__('No', 'streamit')
            ) ,
            'required' => array(
                'display_banner',
                '=',
                'yes'
            ) ,
            'default' => esc_html__('yes', 'streamit')
        ) ,

        array(
            'id' => 'display_title',
            'type' => 'button_set',
            'title' => esc_html__('Display Breadcrumbs on Title', 'streamit') ,
            'options' => array(
                'yes' => esc_html__('Yes', 'streamit') ,
                'no' => esc_html__('No', 'streamit')
            ) ,
            'required' => array(
                'display_banner',
                '=',
                'yes'
            ) ,
            'default' => esc_html__('yes', 'streamit')
        ) ,


        array(
            'id' => 'breadcum_title_tag',
            'type' => 'select',
            'title' => __('Select Breadcrumbs Title Tag', 'streamit') ,
            'options' => array(
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h5' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6'

            ) ,
            'required' => array(
                'display_title',
                '=',
                'yes'
            ) ,
            'default' => 'h2'
        ) ,

        array(
            'id' => 'bg_title_color',
            'type' => 'color',
            'title' => esc_html__('Set Title Color', 'streamit') ,
            'default'       =>'',
            'mode' => 'background',
            'required' => array(
                'display_title',
                '=',
                'yes'
            ) ,
            'transparent' => false
        ) ,

        array(
            'id'       => 'bg_type',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Banner Background Type', 'streamit' ),
            'options'  => array(
                '1' => 'Color',
                '2' => 'Image',
                '3' => 'Video'
            ),
            'default'  => '1'
        ),

        array(
            'id'       => 'banner_image',
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__( 'Set Body Image','streamit'),
            'read-only'=> false,
            'required'  => array( 'bg_type', '=', '2' ),
            'subtitle' => esc_html__( 'Upload Image for your body.','streamit'),
            'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/bg.jpg' ),
        ),

        array(
            'id'            => 'bg_color',
            'type'          => 'color',
            'title'         => esc_html__( 'Set Background Color', 'streamit' ),
            'required'  => array( 'bg_type', '=', '1' ),
            'mode'          => 'background',
            'transparent'   => false
        ),

        array(
            'id'       => 'bg_video_link',
            'type'     => 'text',
            'title'    => esc_html__( 'Your Video Path', 'streamit' ),
            'required'  => array( 'bg_type', '=', '3' ),
            'subtitle' => esc_html__( 'Upload video in media and paste video link over here.', 'streamit' ),
            'default'  => esc_html__('http://localhost/streamit/wordpress/wp-content/uploads/2019/08/SampleVideo.mp4','streamit' ),
        ),

        array(
            'id'       => 'bg_opacity',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Background Opacity Color', 'streamit' ),
            'required' => array(
                array('bg_type','!=','1')
            ),
            'subtitle' => esc_html__( 'Select this option for Background Opacity Color.', 'streamit' ),
            'options'  => array(
                '1' => 'None',
                '2' => 'Dark',
                '3' => 'Custom'
            ),
            'default'  => '1'
        ),


        array(
            'id'            => 'opacity_color',
            'type'          => 'color_rgba',
            'title'         => esc_html__( 'Background Gradient Color', 'streamit' ),
            'required'  => array( 'bg_opacity', '=', '3' ),
            'subtitle'      => esc_html__( 'Choose body Gradient background color', 'streamit' ),
            'default'       => 'rgba(2, 13, 30, 0.9)',
            'transparent'   => false
        ),

    )
));
