<?php
$streamit_options = get_option('streamit_options');
if (isset($streamit_options['streamit_enable_sswitcher'])) {
	if ($streamit_options['streamit_enable_sswitcher']) {
		add_action('wp_enqueue_scripts', 'streamit_style_switcher_styles', 20);
		add_action('wp_footer', 'streamit_style_switcher');
	}
}

function streamit_style_switcher_styles()
{

	// Add iq-style-switcher.js file
	wp_enqueue_script('iq-style-switcher-js', get_template_directory_uri() . '/assets/js/iq-style-switcher.js', array(), '20140826', false);
	// Load iq-style-switcher css style
	wp_enqueue_style('iq-style-switcher-css', get_template_directory_uri() . '/assets/css/iq-style-switcher.css', array(), '1.0.0');
}

//iq Style Switcher
function streamit_style_switcher()
{
	$streamit_options = get_option('streamit_options');
	$options = $streamit_options['streamit_layout_mode_options'];
?>

	<div class="iq-theme-feature hidden-xs hidden-sm hidden-md">
		<div class="iq-switchbuttontoggler"><i class="fa fa-cog"></i></div>
		<div class="spanel">
			<div id="test"></div>
			<form name="styleswitcher" action="<?php echo esc_url(home_url('/')); ?>" method="post">
				<div class="presets">
					<ul id="preset" class="preset">

						<?php if ($options == 2) { ?>
							<li class="active"><a class="ltr" id="ltr" href="?preset=2">LTR<input name="b" type="radio" value="LTR" hidden></a></li>
							<li><a class="rtl" href="?preset=1" id="rtl">RTL<input name="b" type="radio" value="RTL" hidden></a></li>
						<?php } else { ?>
							<li class="active"><a class="ltr" id="ltr" href="?preset=1">LTR<input name="b" type="radio" value="1" hidden></a></a></li>
							<li><a class="rtl" href="?preset=2" id="rtl">RTL<input name="b" type="radio" value="2" hidden></a></a></li>
						<?php } ?>
					</ul>
				</div>
			</form>
		</div>
	</div>
<?php
}
