<?php
if(!class_exists('ReduxFramework')){
	return;
}

add_action( 'wp_enqueue_scripts', 'streamit_color_options' , 20);
function streamit_color_options()
{
    $streamit_options = get_option('streamit_options');
    
        $color_var = ':root { ';
        if(!empty($streamit_options['primary_color']))
        {
            $color = $streamit_options['primary_color'];
            $color_var .= ' --iq-primary: '.$color.' !important;';
        }
        if(!empty($streamit_options['secondary_color']))
        {
            $color = $streamit_options['secondary_color'];
            $color_var .= ' --iq-secondary: '.$color.' !important;';
        }
        if(!empty($streamit_options['text_color']))
        {
            $color = $streamit_options['text_color'];
            $color_var .= ' --iq-body-text: '.$color.' !important;';
        }
        if(!empty($streamit_options['title_color']))
        {
            $color = $streamit_options['title_color'];
            $color_var .= ' --iq-white-color: '.$color.' !important;';
        }
        if(!empty($streamit_options['primary_color_hover']))
        {
            $color = $streamit_options['primary_color_hover'];
            $color_var .= ' --iq-primary-hover: '.$color.' !important;';
        }
        if(!empty($streamit_options['opt_color_gradient']['from']))
        {
            $color = $streamit_options['opt_color_gradient']['from'];
            $from_rgb = implode(',', hex2rgb($streamit_options['opt_color_gradient']['from']));
            $color_var .= ' --iq-form-gradient-color: rgba('.$from_rgb.',0) !important;';
        }
        if(!empty($streamit_options['opt_color_gradient']['to']))
        {
            $color = $streamit_options['opt_color_gradient']['to'];
            $to_rgb = implode(',', hex2rgb($streamit_options['opt_color_gradient']['to']));
            $color_var .= ' --iq-to-gradient-color: rgba('.$to_rgb.',0.3) !important;';
        }

       
        $color_var .='}';  
        wp_add_inline_style('streamit-style', $color_var);
    
}


function streamit_banner_title_color() {     
    //Set Body Color
    $streamit_options = get_option('streamit_options');
    $bg_title_color = $streamit_options['bg_title_color'];
    $bn_title_color = "";

    if(!empty($bg_title_color)){
        $bn_title_color .="
        .iq-breadcrumb-one h2{
            color: $bg_title_color !important;
        }"; 
    }
    wp_add_inline_style( 'streamit-style', $bn_title_color );
}
add_action( 'wp_enqueue_scripts', 'streamit_banner_title_color' , 20);

function streamit_layout_color() {     
    //Set Body Color
    $streamit_options = get_option('streamit_options');
    $streamit_layout_color = $streamit_options['streamit_layout_color'];
    $body_accent_color = "";
    
    if($streamit_options['layout_set'] == "1"){

        if( !empty($streamit_layout_color)) {
            $body_accent_color .= "
            body {
                background-color: $streamit_layout_color !important;
            }"; 
        }
    }
    else{ $body_accent_color = ""; }

    wp_add_inline_style( 'streamit-style', $body_accent_color );
}
add_action( 'wp_enqueue_scripts', 'streamit_layout_color' , 20);

function streamit_loader_color() {
    //Set Loader Background Color
    $streamit_options = get_option('streamit_options');
    $loader_color = $streamit_options['loader_color'];
    $ld_color = "";

    if( !empty($loader_color) && $loader_color != '#ffffff') {
        $ld_color .= "
        #loading {
            background : $loader_color !important;
        }"; 
    }
    wp_add_inline_style( 'streamit-style', $ld_color );
}
add_action( 'wp_enqueue_scripts', 'streamit_loader_color' , 20);

function streamit_bg_color() {
    //Set Background Color
    $streamit_options = get_option('streamit_options');
    $bg_color = '';
    if(isset($streamit_options['bg_color'])) {
        $bg_color = $streamit_options['bg_color'];
    }
    $background_color = "";

    if($streamit_options['bg_type'] == "1"){
        if( !empty($bg_color) && $bg_color != '#ffffff') {
            $background_color .= "
            .iq-bg-over {
                background : $bg_color !important;
            }"; 
        }
    }
    wp_add_inline_style( 'streamit-style', $background_color );
}
add_action( 'wp_enqueue_scripts', 'streamit_bg_color' , 20);

function streamit_opacity_color() {
    //Set Background Opacity Color
    $streamit_options = get_option('streamit_options');
    if($streamit_options['bg_opacity'] == "3"){
    $bg_opacity = $streamit_options['opacity_color']['rgba'];
    }
    $op_color = "";

    if($streamit_options['bg_opacity'] == "3"){
    if( !empty($bg_opacity) && $bg_opacity != '#ffffff') {
        $op_color .= "
        .breadcrumb-video::before,.breadcrumb-bg::before, .breadcrumb-ui::before {
            background : $bg_opacity !important;
        }"; 
        }
    }
    wp_add_inline_style( 'streamit-style', $op_color );
}
add_action( 'wp_enqueue_scripts', 'streamit_opacity_color' , 20);

function streamit_header_radio() {
    //Set Text Logo Color
    $streamit_options = get_option('streamit_options');
    $logo = $streamit_options['header_color'];
    $logo_color = "";

    if($streamit_options['header_radio'] == "1"){
        if( !empty($logo) && $logo != '#ffffff') {
            $logo_color .= "
            .logo-text {
                color : $logo !important;
            }"; 
        }
    }
    wp_add_inline_style( 'streamit-style', $logo_color );
}
add_action( 'wp_enqueue_scripts', 'streamit_header_radio' , 20);

function streamit_footer_color() {
    //Set Footer Background Color
    $streamit_options = get_option('streamit_options');
    if($streamit_options['change_footer_color'] == "0"){
    $f_color = $streamit_options['footer_color'];
    }
    $footer_color = "";
    
    if(function_exists('get_field'))
    {
        $page_id_header = get_queried_object_id();

        $key_header_back = get_field('key_dark_header' , $page_id_header);
        if(isset($key_header_back['name_menu_has_dark']))
        $has_dark = $key_header_back['name_menu_has_dark'];
        if(isset($key_header_back['name_back_color']))
        $f_back_color = $key_header_back['name_back_color'];
        
    }

    
    if(isset($has_dark) && $has_dark == 'yes')
    {
        if(isset($f_back_color) && !empty($f_back_color) ){
                    $footer_color .= "
                    .iq-over-dark-90 {
                        background : $f_back_color !important;
                    }";
        }
    }
    else if($streamit_options['change_footer_color'] == "0"){
        if( !empty($f_color) && $f_color != '#ffffff') {
            $footer_color .= "
            .iq-over-dark-90,  footer {
                background-color : $f_color !important;
            }"; 
        }
    }else{ $footer_color = ''; }
    wp_add_inline_style( 'streamit-style', $footer_color );
}
add_action( 'wp_enqueue_scripts', 'streamit_footer_color' , 20);


function streamit_watchlist_button() {
    //Set watchlist button
    $streamit_options = get_option('streamit_options');
    $watchlist = $streamit_options['streamit_display_watchlist'];
    $watchlist_display = "";

    if($watchlist == 'no' ){
            $watchlist_display .= "
            .music-play-lists li:last-child {
                display : none !important;
            }"; 
    }
    wp_add_inline_style( 'streamit-style', $watchlist_display );
}
add_action( 'wp_enqueue_scripts', 'streamit_watchlist_button' , 20);