<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>
<div id="comments" class="comments-area validate-form">
    <?php
    // You can start editing here -- including this comment!
    if ( have_comments() ) : ?>
        <h3 class="comments-title">
            <?php
            $comments_number = get_comments_number();
            echo esc_html($comments_number);
            ?>
            <?php echo esc_html__('Comment', 'streamit'); ?>
        </h3>

        <ol class="commentlist">
            <?php wp_list_comments( array(
                'callback' => 'streamit_comments',
                'style'      => 'ol',
                //'short_ping' => true,
                //'avatar_size'=> 34,
            ) );
            ?>
        </ol><!-- .commentlist -->

        <?php the_comments_pagination( array(
            'prev_text' => streamit_get_svg( array( 'icon' => 'arrow-left' ) ) . '<span class="screen-reader-text">' . esc_html__( 'Previous', 'streamit' ) . '</span>',
            'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next', 'streamit' ) . '</span>' . streamit_get_svg( array( 'icon' => 'arrow-right' ) ),
        ) );

    endif; // Check for have_comments().

    // If comments are closed and there are comments, let's leave a little note, shall we?
    if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>

        <p class="no-comments"><?php esc_html__( 'Comments are closed.', 'streamit' ); ?></p>
    <?php
    endif;

    $args = array(
        'label_submit' => esc_html__( 'Post Comment','streamit' ),
        'comment_notes_before' => esc_html__('Your email address will not be published. Required fields are marked *','streamit').'',
        'comment_field' => '<div class="comment-form-comment"><textarea id="comment" name="comment" aria-required="true" placeholder="Comment"></textarea></div>',
        'fields' => array(
            'author' => '<div class="row"><div class="col-lg-4"><div class="comment-form-author"><input id="author" name="author" aria-required="true" placeholder="Name*" /></div></div>',
            'email' => '<div class="col-lg-4"><div class="comment-form-email"><input id="email" name="email" placeholder="Email*" /></div></div>',
            'url' => '<div class="col-lg-4"><div class="comment-form-url"><input id="url" name="url" placeholder="Website" /></div></div></div>',
        ),
        'submit_button'	=> '
		        <button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s" >
		            <span class="iq-btn-text-holder">'.esc_html__('Post Comment','streamit').'</span>
		        </button>',
    );

    comment_form($args);
    ?>
    <div class="wpcf7-response-output error-msg" aria-hidden="true" style="display: none;"></div>
</div><!-- #comments -->
