import mysql.connector

from secrets import db_config



def load_db():
    db_info = db_config()
    mydb = mysql.connector.connect(
        host=db_info[0],
        user=db_info[2],
        passwd=db_info[3],
        database=db_info[1]
    )
    return mydb


def insert_bkash_transaction(serial_no, date_and_time, from_account, transaction_type, to_account, outlet_name, transaction_id, reference, amount, sync_time, status, invoice, approver):
    mydb = load_db()
    mycursor = mydb.cursor()
    sql = " INSERT INTO tbl_bkash(serial_no, date_and_time, from_account, transaction_type, to_account, outlet_name," \
          " transaction_id, reference, amount, sync_time, status, invoice, approver) VALUES (%s, %s, %s, %s, %s, %s," \
          " %s, %s, %s, %s, %s, %s, %s)"
    val = (serial_no, date_and_time, from_account, transaction_type, to_account, outlet_name, transaction_id, reference, amount, sync_time, status, invoice, approver)
    mycursor.execute(sql, val)
    mydb.commit()

def check_bkash_transaction(transaction_id, transaction_type):
    mydb = load_db()
    mycursor = mydb.cursor()
    sql = "SELECT transaction_id" \
          " FROM tbl_bkash WHERE transaction_id = %s AND transaction_type = %s"
    mycursor.execute(sql, (transaction_id, transaction_type))
    myresult = mycursor.fetchall()
    return myresult