import time
import datetime

from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait

from monthly.date_util import first_date
from secrets import key_bkash
from util_chromedriver import driver_de_headless
from util_db import insert_bkash_transaction, check_bkash_transaction


def bkash_login():

    x = datetime.datetime.now()
    str_date = x.strftime("%d")
    str_month = x.strftime("%b")
    str_year = x.strftime("%Y")
    str_starting_date = '01-' + str_month + '-' + str_year
    str_full_today = str_date + '-' + str_month + '-' + str_year
    print(str_full_today)
    print(str_starting_date)
    date_positioning = first_date()
    date_picker_xpath = '//*[@id="ui-datepicker-div"]/table/tbody/tr[1]/td['+str(date_positioning)+']/a'
    print(date_positioning)
    # print(payload)
    driver = driver_de_headless()
    #driver = driver_de_head()
    bkash_credential = key_bkash()
    driver.get("https://www.bkashcluster.com:9081/mr_portal/")
    time.sleep(3)

    try:
        # element = driver.find_element_by_xpath('//*[@id="login_box"]/div[2]/form/fieldset/div[1]/div[2]/input')
        element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.NAME, 'j_username'))
        )
    finally:
        element.send_keys(bkash_credential[0])
        # element.send_keys(Keys.ENTER)

    try:
        # element = driver.find_element_by_xpath('//*[@id="login_box"]/div[2]/form/fieldset/div[1]/div[2]/input')
        pass_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.NAME, 'j_password'))
        )
    finally:
        pass_element.send_keys(bkash_credential[1])
        pass_element.send_keys(Keys.ENTER)
    time.sleep(5)


    try:
        # element = driver.find_element_by_xpath('//*[@id="login_box"]/div[2]/form/fieldset/div[1]/div[2]/input')
        trx_element = WebDriverWait(driver, 15).until(
            # EC.presence_of_element_located((By.XPATH, '//*[@id="floatMenu"]/li[3]/a'))
            EC.presence_of_element_located((By.XPATH, '//*[@id="floatMenu"]/li[4]/a'))
        )
    finally:
        trx_element.click()
        time.sleep(10)


    try:
        start_month_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.XPATH, '//*[@id="txt_from_date"]'))
        )
    finally:
        start_month_element.send_keys(str_starting_date)
        time.sleep(2)



    try:
        picker_start_month_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.XPATH, date_picker_xpath))
        )
    finally:
        picker_start_month_element.click()
        time.sleep(2)




    try:
        today_month_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.XPATH, '//*[@id="txt_end_date"]'))
        )
    finally:
        today_month_element.click()
        today_month_element.send_keys(Keys.ENTER)
        time.sleep(2)





    try:
        view_report_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.XPATH, '//*[@id="button_tr"]/td[1]/button'))
        )
    finally:
        view_report_element.click()
        time.sleep(5)
        view_report_element.click()
        time.sleep(15)

    row_count = len(driver.find_elements_by_xpath("//*[@id='report_data_holder']/center/table/tbody/tr"))
    coloumn_count = len(driver.find_elements_by_xpath('//*[@id="report_data_holder"]/center/table/tbody/tr[1]/th'))
    print("ROw Count", row_count)
    print("Coloumn Count", coloumn_count)

    first_part = "//*[@id='report_data_holder']/center/table/tbody/tr["
    second_part = "]/td["
    third_part = "]"

    for n in range(2,row_count+1):
        serial_no = "0"
        date_and_time = "0"
        from_account = "0"
        transaction_type = "0"
        to_account = "0"
        outlet_name = "0"
        transaction_id = "0"
        reference = "0"
        amount = "0"
        x = datetime.datetime.now()
        sync_time = x.strftime("%Y-%m-%d %H:%M:%S")
        # sync_time = "0"
        status = "0"
        invoice = "0"
        approver = "0"
        for m in range(1,coloumn_count+1):
            final_part = first_part+str(n)+second_part+str(m)+third_part
            table_data = driver.find_element_by_xpath(final_part).text
            if m == 1:
                serial_no = table_data
            elif m == 2:
                date_and_time = table_data
            elif m == 3:
                from_account = table_data
            elif m == 4:
                transaction_type = table_data
            elif m == 5:
                to_account = table_data
            elif m == 6:
                outlet_name = table_data
            elif m == 7:
                transaction_id = table_data
            elif m == 8:
                reference = table_data
            elif m == 9:
                amount = table_data

            print(table_data, end = " ")

        # print(serial_no + "-" + date_and_time + "-" + from_account + "-" + transaction_type + "-" + to_account + "-" + outlet_name + "-" + transaction_id + "-" + reference + "-"  + amount + "-" + sync_time + "-" + status + "-" + invoice + "-" + approver + "-")
        if len(check_bkash_transaction(transaction_id, transaction_type)) == 0:
           insert_bkash_transaction(serial_no, date_and_time, from_account, transaction_type, to_account, outlet_name, transaction_id, reference, amount, sync_time, status, invoice, approver)
           print("inserted")
        else:
           print(transaction_id)
        print(" ")

    time.sleep(1)
    driver.close()
