import time
import datetime

from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait

from selenium.common.exceptions import NoSuchElementException
from selenium.common.exceptions import WebDriverException
from selenium.common.exceptions import TimeoutException

from secrets import key_bkash
from util_chromedriver import driver_de_head, driver_de_headless
from util_db import insert_bkash_transaction, check_bkash_transaction


def bkash_login():
    x = datetime.datetime.now()
    str_date = x.strftime("%d")
    str_month = x.strftime("%b")
    str_year = x.strftime("%Y")
    str_starting_date = '01-' + str_month + '-' + str_year
    str_full_today = str_date + '-' + str_month + '-' + str_year
    print(str_full_today)
    print(str_starting_date)
    #    driver = driver_de_headless()
    driver = driver_de_head()
    bkash_credential = key_bkash()
    try:
        driver.get("https://www.bkashcluster.com:9081/mr_portal/")
    except WebDriverException as exception:
        print("WebDriverException")
    time.sleep(3)

    try:
        element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.NAME, 'j_username'))
        )
        element.send_keys(bkash_credential[0])
    except TimeoutException as exception:
        print("TimeoutException 1")

    try:
        pass_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.NAME, 'j_password'))
        )
        pass_element.send_keys(bkash_credential[1])
        pass_element.send_keys(Keys.ENTER)
    except TimeoutException as exception:
        print("TimeoutException 2")
    time.sleep(5)

    try:
        trx_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.XPATH, '//*[@id="floatMenu"]/li[2]/a'))
        )
        trx_element.click()
        time.sleep(10)
    except TimeoutException as exception:
        print("TimeoutException 3")

    try:
        view_report_element = WebDriverWait(driver, 15).until(
            EC.presence_of_element_located((By.XPATH, '//*[@id="button_tr"]/td[1]/button'))
        )

        view_report_element.click()
        time.sleep(5)
        view_report_element.click()
        time.sleep(5)
    except TimeoutException as exception:
        print("TimeoutException 4")

    row_count = len(driver.find_elements_by_xpath("//*[@id='report_data_holder']/center/table/tbody/tr"))
    coloumn_count = len(driver.find_elements_by_xpath('//*[@id="report_data_holder"]/center/table/tbody/tr[1]/th'))
    print("ROw Count", row_count)
    print("Coloumn Count", coloumn_count)

    first_part = "//*[@id='report_data_holder']/center/table/tbody/tr["
    second_part = "]/td["
    third_part = "]"

    for n in range(2, row_count + 1):
        serial_no = "0"
        date_and_time = "0"
        from_account = "0"
        transaction_type = "0"
        to_account = "0"
        outlet_name = "GGNBBU"
        transaction_id = "0"
        reference = "0"
        amount = "0"
        x = datetime.datetime.now()
        sync_time = x.strftime("%Y-%m-%d %H:%M:%S")
        # sync_time = "0"
        status = "0"
        invoice = "0"
        approver = "0"
        for m in range(1, coloumn_count + 1):
            final_part = first_part + str(n) + second_part + str(m) + third_part
            try:
                table_data = driver.find_element_by_xpath(final_part).text
            except NoSuchElementException:
                table_data = "-"
                print("Nul Point")
            if m == 1:
                serial_no = table_data
            elif m == 2:
                date_and_time = table_data
            elif m == 3:
                transaction_type = table_data
            elif m == 4:
                from_account = table_data
            elif m == 5:
                to_account = table_data
            elif m == 6:
                amount = table_data
            elif m == 10:
                transaction_id = table_data
            elif m == 11:
                reference = table_data

            print(table_data, end=" ")

        # print(serial_no + "-" + date_and_time + "-" + from_account + "-" + transaction_type + "-" + to_account + "-" + outlet_name + "-" + transaction_id + "-" + reference + "-"  + amount + "-" + sync_time + "-" + status + "-" + invoice + "-" + approver + "-")
        if len(check_bkash_transaction(transaction_id, transaction_type)) == 0:
            insert_bkash_transaction(serial_no, date_and_time, from_account, transaction_type, to_account, outlet_name,
                                     transaction_id, reference, amount, sync_time, status, invoice, approver)
            print("inserted")
        else:
            print(transaction_id)
        print("old entry ")

    time.sleep(1)
    driver.close()
    driver.quit()
