<?php get_header(); ?>
    <div class="Body">
        <div class="Main Container">
                <article>
                    <div class="Top AAIco-sort_by_alpha">
                        <h1 class="Title"><?php _e('Movies and Series by Letter', 'toroflix'); ?></h1>
                    </div>
                    <?php $alphabet = get_option('alphabet_show');
                    if($alphabet){
                            get_template_part('public/partials/template/letters');
                        } ?>
                    <?php if(have_posts()) : ?>
                    <div class="TPTblCn TPTblCnMvs">
                        <table>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th colspan="2"><?php _e('Title', 'toroflix'); ?></th>
                                    <th><?php _e('Type', 'toroflix'); ?></th>
                                    <th><?php _e('Year', 'toroflix'); ?></th>
                                    <th><?php _e('Duration', 'toroflix'); ?></th>
                                    <th><?php _e('Genres', 'toroflix'); ?></th>
                                    <th><?php _e('Votes', 'toroflix'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count=1; while(have_posts()) : the_post(); 
                                    $loop = new TOROFLIX_Movies(); ?>
                                    <tr>
                                        <td><span class="Num"><?php echo $count; $count++; ?></span></td>
                                        <td class="MvTbImg">
                                            <a href="<?php the_permalink(); ?>" class="MvTbImg">
                                                <?php echo $loop->image(get_the_ID(), 'w92') ?>
                                            </a>
                                        </td>
                                        <td class="MvTbTtl">
                                            <a href="<?php the_permalink(); ?>" class="MvTbImg">
                                                <strong><?php the_title(); ?></strong>
                                            </a>
                                        </td>
                                        <td><?php echo $loop->is_serie_movie(); ?></td>
                                        <td><?php echo $loop->year(); ?></td>
                                        <td>
                                            <p class="Info">
                                                <span class="Dur"><?php echo $loop->duration(); ?></span>
                                            </p>
                                        </td>
                                        <td><?php echo $loop->get_categories(); ?></td>
                                        <td>
                                            <div class="post-ratings">
                                                <img src="<?php echo TOROFLIX_DIR_URI; ?>public/img/star-on.svg" alt="img">
                                            </div>
                                        </td>
                                    </tr>
                                <?php endwhile; ?> 
                            </tbody>
                        </table>
                    </div>
                    <div class="wp-pagenavi">
                        <?php echo TOROFLIX_Add_Theme_Support::toroflix_pagination(); ?>
                    </div>
                    <?php else: ?>
                        <section class="error-404 not-found AAIco-sentiment_very_dissatisfied">
                            <header class="Top" >
                                <h1 class="Title"><?php esc_html_e( 'Oops! no post found', 'toroflix' ); ?></h1>
                                <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'toroflix' ); ?></p>
                            </header>
                        </section>    
                    <?php endif; ?> 
                </article>
        </div>
    </div>
<?php get_footer(); ?>