<?php 

/*Carousel Letter*/
if ( ! function_exists( 'episode_content_carousel' ) ) {
	function episode_content_carousel() { 
		$alphabet = get_option('alphabet_show');
        if($alphabet){
	        	get_template_part('public/partials/template/letters');
	        } 
	}
}
add_action( 'episode_content', 'episode_content_carousel', 10 );




/*Info Episode*/
if ( ! function_exists( 'episode_content_info' ) ) {
	function episode_content_info($data) { 
		$term               = $data['term']; 
		$term_id            = $data['term_id'];
		$links              = $data['links'];
		$links['downloads'] = !empty($links['downloads']) ? $links['downloads'] : ''; 
		$links['online']    = !empty($links['online']) ? $links['online'] : '';
		$loop               = new TOROFLIX_Movies();
		$sidebar_position   = $loop->sidebar_position('sidebar_type_movies_series');
	    ?>
		<div class="TpRwCont <?php echo $sidebar_position; ?>">
            <main>
            	<?php 

            	#Info Episode
            	if($links['online'])
	                get_template_part( 'public/partials/template/episode/episode', 'nolink', array( 'term_id' => $term_id, 'term' => $term, 'image' => false ) ); 

	            #List of episodes
	            get_template_part( 'public/partials/template/episode/episode', 'list', array( 'term_id' => $term_id, 'term' => $term ) ); 
	            
	            #Download 
	            if($links['downloads'])
	            	get_template_part( 'public/partials/template/episode/episode', 'download', array( 'links' => $links['downloads'], 'term_id' => $term_id, 'term' => $term ) );
	            ?>
            </main>
            <?php if($sidebar_position != 'NoSdbr') get_sidebar(); ?>
        </div>
	<?php }
}
add_action( 'episode_content', 'episode_content_info', 20 );






if ( ! function_exists( 'episode_content_related' ) ) {
	function episode_content_related($data) {
		$id = $data['serie_id'];
		$custom_taxterms = wp_get_object_terms( $id, 'category', array('fields' => 'ids') );
        $args = array(
            'post_type' => 'series',
		    'post_status' => 'publish',
		    'posts_per_page' => 15,
		    'orderby' => 'rand',
		    'tax_query' => array(
		        array(
		            'taxonomy' => 'category',
		            'field' => 'id',
		            'terms' => $custom_taxterms
		        )
		    ),
		    'post__not_in' => array($id),
        ); 
        $the_query = new WP_Query( $args );
        if ( $the_query->have_posts() ) : ?>
			<section>
			    <div class="Top AAIco-movie_filter">
			        <div class="Title"><?php _e('More titles like this', 'toroflix'); ?></div>
			    </div>
			    <div class="MovieListTop owl-carousel Serie">
			        <?php while ( $the_query->have_posts() ) : $the_query->the_post(); 
			        	get_template_part('public/partials/template/loop', 'secondary');
			        endwhile; ?>
			    </div>
			</section>
		<?php endif; wp_reset_query();
	}
}
add_action( 'episode_content', 'episode_content_related', 30 );