<?php 
add_action( 'widgets_init', function(){
    register_widget( 'toroflix_genres_widget' );
});
class toroflix_genres_widget extends WP_Widget {
    #Sets up the widgets name etc
    public function __construct() {
        $widget_ops = array(
            'classname' => 'widget_categories',
            'description' => __( 'Show list of all categories', 'toroflix' ),
        );
        parent::__construct( 'toroflix_genres_widget', 'Toroflix: Genres', $widget_ops );
    }
    # Display frontend
    public function widget( $argus, $instance ) {
        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 1000;
        echo $argus['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $argus['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $argus['after_title'];
        } ?>
        <ul>
            <?php
            $categories = get_categories( array(
                'orderby' => 'name',
                'order'   => 'ASC',
                'number' => $number,
            ) );
            foreach( $categories as $category ) { 
                if($categories){ ?>
                <li><a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><?php echo esc_html( $category->name );  ?></a> <?php echo $category->count;  ?></li>
                <?php }
            } ?>   
        </ul>
        <?php echo $argus['after_widget'];
    }
    #Parameters Form of Widget
    public function form( $instance ) {
        $title  = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $number = isset( $instance['number'] ) ? absint( $instance['number'] ) : false;
        ?>
        <div class="wdgt-tt">
            <div>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'toroflix' ); ?></label>
                <div class="fr-input">
                    <span class="dashicons dashicons-edit-large"></span>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
                </div>
                    
            </div>

            <div>
                <label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of items', 'toroflix' ); ?></label>
                 <div class="fr-input">
                    <span class="dashicons dashicons-shortcode"></span>
                    <input class="tiny-text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="number" step="1" min="1" value="<?php echo $number; ?>" size="3" />
                </div>
            </div>
        </div>
        <?php
    }
    #Save Data
    public function update( $new_instance, $old_instance ) {
        // processes widget options to be saved
        foreach( $new_instance as $key => $value )
        {
            $updated_instance[$key] = sanitize_text_field($value);
        }
        return $updated_instance;
    }
}