<?php 
/*
template name: Movies Page
*/
get_header(); ?>
    <div class="bd">
        <?php if(is_front_page()){
            get_template_part( 'public/partials/template/home', 'search' );
        } ?>
        <div class="dfxc">
            <main class="main-site">
                <section class="section movies">
                    <header class="section-header">
                        <div class="rw alg-cr jst-sb">
                            <h1 class="section-title"><?php the_title(); ?></h1>
                        </div>
                    </header>
                    <?php if(is_front_page()) {
                        $paged = get_query_var( 'page' ) ? get_query_var( 'page' ) : 1;
                    } else {
                        $paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
                    }
                    $args = array (
                        'post_type'      => array('movies'),
                        'paged'          => $paged,
                        'posts_per_page' => get_option('posts_per_page'),
                    );
                    query_posts($args); 
                    if ( have_posts() ) : ?>
                        <div class="aa-cn" id="aa-movies">
                            <div id="movies-a" class="aa-tb hdd on">
                                <ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e">
                                    <?php 
                                    while ( have_posts() ) : the_post();
                                        get_template_part('public/partials/template/movies', 'main');
                                    endwhile; ?> 
                                </ul>
                            </div>
                        </div>
                        <nav class="navigation pagination">
                            <?php torofilm_pagination(); ?>
                        </nav>
                    <?php endif; wp_reset_query();  ?>
                </section>
                <?php if(is_front_page() or is_home()){
                    if (!function_exists('dynamic_sidebar') || !dynamic_sidebar('sidebar-home')) : endif; 
                } ?>
            </main>
            <?php get_sidebar(); ?>
        </div>
    </div>
<?php get_footer();  ?>