<?php
class TOROFLIX_Posts
{   
    public static function tr_links_movies($post_id)
    {
        $links_total = get_post_meta($post_id, 'trgrabber_tlinks', true) == '' ? 0 : get_post_meta($post_id, 'trgrabber_tlinks', true) - 1;
        $links = array();
        if (isset($links_total)) {
            for ($i = 0; $i <= $links_total; $i++) {
                $link = unserialize(get_post_meta($post_id, 'trglinks_' . $i, true));
                $type = $link['type'] == '' ? 1 : $link['type'];
                $lang = $link['lang'] == '' ? 0 : $link['lang'];
                $quality = $link['quality'] == '' ? 0 : $link['quality'];
                $server = $link['server'] == '' ? 0 : $link['server'];
                $linkk = $link['link'] == '' ? '' : trgrabber_base64de($link['link']);
                $date = $link['date'] == '' ? '' : $link['date'];
                if ($type == 1 and $linkk != '') {
                    $links['online'][] = array(
                        'i' => $i,
                        'lang' => $lang,
                        'quality' => $quality,
                        'server' => $server,
                        'link' => $linkk,
                        'date' => $date
                    );
                } elseif ($linkk != '') {
                    $links['downloads'][] = array(
                        'i' => $i,
                        'lang' => $lang,
                        'quality' => $quality,
                        'server' => $server,
                        'link' => $linkk,
                        'date' => $date
                    );
                }
            }
            return $links;
        }
    }
    public function trailer($post_id)
    {
        $trailer = get_post_meta($post_id, 'field_trailer', true);
        if (!$trailer)
            $trailer = false;
        return $trailer;
    }
    public function get_categories()
    {
        global $post;
        $cats = false;
        $terms = get_the_category($post->ID);
        if (!empty($terms)) {
            $categories = '';
            foreach ($terms as $term) {
                $categories = '<a href="' . get_category_link($term) . '">' . $term->name . '</a>';
            }
            $cats = $categories;
        }
        return $cats;
    }
    public function get_tags()
    {
        global $post;
        return get_the_tags($post->ID);
    }
    public function get_comments()
    {
        global $post;
        return get_comments_number($post->ID);
    }
    #List categories Posts
    public function categories()
    {
        global $post;
        $terms = wp_get_post_terms($post->ID, array('category'));
        if ($terms) {
            $categories = array();
            foreach ($terms as $term) {
                $categories[] = '<a href="' . get_term_link($term) . '">' . $term->name . '</a>';
            }
        }
        $cats = implode(', ', $categories);
        return $cats;
    }
}
