<article id="post-<?php the_ID(); ?>" class="col-lg-3 col-md-4 col-sm-6 wl-child">
    <div class="block-images position-relative watchlist-img">
        <?php
        $streamit_options = get_option('streamit_options');

        if (isset($streamit_options['streamit_display_image'])) {
            $options = $streamit_options['streamit_display_image'];
            if ($options == "yes") {
                if (has_post_thumbnail()) {
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
        ?>
                    <div class="img-box">
                        <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="image">
                    </div>
        <?php }
            }
        } ?>
        <div class="block-description">
            <h6 class="iq-title">
                <a href="<?php echo esc_url(get_the_permalink()); ?>">
                    <?php the_title(); ?>
                </a>
            </h6>
            <div class="movie-time d-flex align-items-center my-2">
                <span class="text-white"><?php echo get_the_date(); ?></span>
            </div>
            <div class="hover-buttons">
                <a href="<?php echo esc_url(get_the_permalink()); ?>" class="btn btn-hover iq-button">
                    <i class="fa fa-play mr-1" aria-hidden="true"></i>
                    <?php _e('Play Now', 'streamit') ?>
                </a>
            </div>
        </div>
    </div>
</article>