<?php

/**
 * Template Name: Streamit Full Width
 * Template Post Type: post, movie , tv_show , video , episode
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.0
 */
get_header();
$streamit_options = get_option('streamit_options');

$row = "row";
$col = "col-lg-12 col-sm-12";
$flag = 0;
$sidecol = "col-lg-4 col-sm-12 sidebar-service-right";



if (function_exists('get_field') && class_exists('ReduxFramework')) {
	$options = $streamit_options['streamit_page_variation'];
	if (get_field('acf_key_sidebar') != 'default') {
		$acf_opt = get_field('acf_key_sidebar');
		if ($acf_opt == "1") {
			$row = "row";
			$col = "col-lg-8 col-sm-12";
			$sidecol = "col-lg-4 col-sm-12 sidebar-service-right";
			if (is_active_sidebar('page-1')) {
				$flag = 1;
			}
		}
		if ($acf_opt == "2") {
			$row = "row flex-row-reverse";
			$col = "col-lg-8 col-sm-12";
			$sidecol = "col-lg-4 col-sm-12 sidebar-service-left";
			if (is_active_sidebar('page-1')) {
				$flag = 1;
			}
		}
	} else {
		if ($options == 1) {
			$row = "row";
			$col = "col-lg-8 col-sm-12";
			$sidecol = "col-lg-4 col-sm-12 sidebar-service-right";
			if (is_active_sidebar('page-1')) {
				$flag = 1;
			}
		}

		if ($options == 2) {
			$row = "row flex-row-reverse";
			$col = "col-lg-8 col-sm-12";
			$sidecol = "col-lg-4 col-sm-12 sidebar-service-left";
			if (is_active_sidebar('page-1')) {
				$flag = 1;
			}
		}
	}
}

if (!empty($options)) {
?>
			<div class="<?php echo esc_attr($col); ?>">

				<?php
				if (is_singular('movie')) {
					get_template_part('single', 'movie');
				} else if(is_singular('video')){
					get_template_part('single', 'video');
				} else if(is_singular('tv_show')){
					get_template_part('single', 'tv_show');
				} else if(is_singular('episode')){
					get_template_part('single', 'episode');
				} else {
					get_template_part('single');
				}
				wp_reset_postdata();
				?>
			</div>

			<?php
			if ($flag == 1) {
			?>
				<div class="<?php echo esc_attr($sidecol); ?>">
					<?php dynamic_sidebar('page-1'); ?>
				</div>
			<?php
			}
			?>

<?php
}
?>
<?php get_footer();
